/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.TiffModule;
import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExif;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExifIFD;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ListIterator;

public final class JpegExif {
    private boolean _exifProfileOK = false;

    public static boolean isTiffAvailable() {
        try {
            Class<?> clazz = Class.forName("edu.harvard.hul.ois.jhove.module.TiffModule");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepInfo readExifData(DataInputStream dataInputStream, JhoveBase jhoveBase, int n) {
        RandomAccessFile randomAccessFile = null;
        File file = null;
        FileOutputStream fileOutputStream = null;
        RepInfo repInfo = new RepInfo("tempfile");
        try {
            file = jhoveBase.tempFile();
        }
        catch (IOException iOException) {
            repInfo.setMessage(new ErrorMessage("Error creating temporary file. Check your configuration: " + iOException.getMessage()));
            return repInfo;
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            int n2 = jhoveBase.getBufferSize();
            int n3 = n - 8;
            if (n2 <= 0) {
                n2 = 32768;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, n2);
            byte[] byArray = new byte[n2];
            while (n3 > 0) {
                int n4 = n3 < n2 ? n3 : n2;
                n4 = dataInputStream.read(byArray, 0, n4);
                bufferedOutputStream.write(byArray, 0, n4);
                n3 -= n4;
            }
            fileOutputStream.flush();
            TiffModule tiffModule = new TiffModule();
            tiffModule.setByteOffsetValid(true);
            randomAccessFile = new RandomAccessFile(file, "r");
            List list = tiffModule.exifParse(randomAccessFile, repInfo);
            if (list == null) {
                RepInfo repInfo2 = repInfo;
                return repInfo2;
            }
            ListIterator listIterator = list.listIterator();
            boolean bl = true;
            boolean bl2 = false;
            while (listIterator.hasNext()) {
                Object object;
                Object object2;
                Object e = listIterator.next();
                if (e instanceof TiffIFD && bl) {
                    object2 = ((TiffIFD)e).getNisoImageMetadata();
                    repInfo.setProperty(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, object2));
                    bl2 = true;
                    object = new TiffProfileExif();
                    this._exifProfileOK = ((TiffProfile)object).satisfiesProfile((TiffIFD)e);
                }
                if (e instanceof ExifIFD) {
                    Object object3;
                    object2 = (ExifIFD)e;
                    object = ((ExifIFD)object2).getProperty(jhoveBase.getShowRawFlag());
                    List list2 = null;
                    if (object != null) {
                        list2 = ((ExifIFD)object2).exifProps((Property)object);
                    }
                    if (this._exifProfileOK) {
                        object3 = new TiffProfileExifIFD();
                        this._exifProfileOK = ((TiffProfile)object3).satisfiesProfile((IFD)object2);
                    }
                    if (list2 != null) {
                        repInfo.setProperty(new Property("Exif", PropertyType.PROPERTY, PropertyArity.LIST, list2));
                    }
                    if (!bl2) {
                        object3 = ((ExifIFD)object2).getNisoImageMetadata();
                        repInfo.setProperty(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, object3));
                    }
                }
                bl = false;
            }
        }
        catch (IOException iOException) {
            repInfo.setMessage(new ErrorMessage("I/O exception processing Exif metadata: " + iOException.getMessage()));
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (file != null) {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
        return repInfo;
    }

    public boolean isExifProfileOK() {
        return this._exifProfileOK;
    }
}

