/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Callback;
import edu.harvard.hul.ois.jhove.ConfigHandler;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.MacStuff;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.viewer.AppInfoWindow;
import edu.harvard.hul.ois.jhove.viewer.ConfigWindow;
import edu.harvard.hul.ois.jhove.viewer.ModuleInfoWindow;
import edu.harvard.hul.ois.jhove.viewer.PrefsWindow;
import edu.harvard.hul.ois.jhove.viewer.ProgressWindow;
import edu.harvard.hul.ois.jhove.viewer.ViewHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JhoveWindow
extends JFrame
implements Callback,
DropTargetListener {
    private App _app;
    private JhoveBase _base;
    private AppInfoWindow _appInfoWin;
    private ModuleInfoWindow _moduleInfoWin;
    private JMenu _moduleSubmenu;
    private JMenuItem _openFileItem;
    private JMenuItem _openURLItem;
    private JMenuItem _closeAllItem;
    private ButtonGroup _moduleGroup;
    private String syncStr = "";
    private boolean _rawOutput;
    private boolean _doChecksum;
    private ProgressWindow _progWind;
    private ConfigWindow _configWind;
    private PrefsWindow _prefsWindow;
    private File _lastDir;
    private String _selectedModule;
    private ActionListener _moduleMenuListener;
    private JPanel logo;
    private ViewHandler _viewHandler;
    private static int viewWinXPos = 24;
    private static int viewWinYPos = 24;
    private static final int viewWinOrigXPos = 24;
    private static final int viewWinOrigYPos = 24;
    private static final int viewWinXInc = 25;
    private static final int viewWinYInc = 22;
    private static final int appInfoWinXPos = 50;
    private static final int appInfoWinYPos = 45;
    private static final int moduleInfoWinXPos = 100;
    private static final int moduleInfoWinYPos = 90;
    protected Logger _logger;
    private final InvisibleFilenameFilter invisibleFilter = new InvisibleFilenameFilter();

    public JhoveWindow(App app, JhoveBase jhoveBase) {
        super("Jhove");
        Object object;
        Serializable serializable;
        Object object2;
        this._logger = Logger.getLogger("edu.harvard.hul.ois.jhove.viewer");
        this._app = app;
        this._base = jhoveBase;
        this._moduleMenuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JhoveWindow.this._selectedModule = actionEvent.getActionCommand();
            }
        };
        this._lastDir = null;
        this._moduleGroup = new ButtonGroup();
        this.addMenus();
        Container container = this.getContentPane();
        this.setDefaultCloseOperation(3);
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                Module module = (Module)object;
                Module module2 = (Module)object2;
                String string = module.getName();
                String string2 = module2.getName();
                return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
            }
        };
        Vector<String> vector = new Vector<String>(10);
        List list = jhoveBase.getModuleList();
        ArrayList arrayList = new ArrayList(list.size());
        arrayList.addAll(list);
        Collections.sort(arrayList, comparator);
        Iterator iterator = arrayList.iterator();
        vector.add("(None selected)");
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        String string = null;
        while (iterator.hasNext()) {
            object2 = (Module)iterator.next();
            string = object2.getName();
            jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            jRadioButtonMenuItem.setActionCommand(string);
            jRadioButtonMenuItem.addActionListener(this._moduleMenuListener);
            this._moduleSubmenu.add(jRadioButtonMenuItem);
            this._moduleGroup.add(jRadioButtonMenuItem);
        }
        this.logo = new JPanel();
        object2 = JhoveWindow.class.getResource("jhove-logo.gif");
        if (object2 != null) {
            serializable = new ImageIcon((URL)object2);
            serializable.setDescription("Jhove logo");
            this.setNormalBackground();
            object = new JLabel((Icon)((Object)serializable));
            this.logo.add((Component)object);
        }
        serializable = new DropTarget(this.logo, this);
        container.add(this.logo);
        this.pack();
        object = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JhoveWindow.this._base.abort();
            }
        };
        this._progWind = new ProgressWindow((ActionListener)object);
        this._viewHandler = new ViewHandler(this, this._app, this._base);
    }

    private final void addMenus() {
        JMenuItem jMenuItem;
        final JhoveWindow jhoveWindow = this;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this._openFileItem = new JMenuItem("Open file...");
        jMenu.add(this._openFileItem);
        this._openFileItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._openFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JhoveWindow.this.pickAndAnalyzeFile();
            }
        });
        this._openURLItem = new JMenuItem("Open URL...");
        jMenu.add(this._openURLItem);
        this._openURLItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JhoveWindow.this.pickAndAnalyzeURL();
            }
        });
        this._closeAllItem = new JMenuItem("Close all document windows");
        jMenu.add(this._closeAllItem);
        if (!MacStuff.isMacintosh()) {
            jMenuItem = new JMenuItem("Exit");
            jMenu.add(jMenuItem);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
        }
        jMenuItem = new JMenu("Edit");
        jMenuBar.add((JMenu)jMenuItem);
        this._moduleSubmenu = new JMenu("Select module");
        ((JMenu)jMenuItem).add(this._moduleSubmenu);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("(Any)");
        jRadioButtonMenuItem.setActionCommand("");
        jRadioButtonMenuItem.setSelected(true);
        jRadioButtonMenuItem.addActionListener(this._moduleMenuListener);
        this._moduleSubmenu.add(jRadioButtonMenuItem);
        this._moduleGroup.add(jRadioButtonMenuItem);
        this._selectedModule = "";
        JMenuItem jMenuItem2 = new JMenuItem("Edit configuration...");
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JhoveWindow.this.openConfigWindow();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Preferences...");
        ((JMenu)jMenuItem).add(jMenuItem3);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JhoveWindow.this._prefsWindow == null) {
                    JhoveWindow.this._prefsWindow = new PrefsWindow(jhoveWindow);
                    JhoveWindow.this._prefsWindow.setLocation(180, 160);
                    JhoveWindow.this._prefsWindow.pack();
                }
                JhoveWindow.this._prefsWindow.saveAndShow();
            }
        });
        JMenu jMenu2 = new JMenu("Help");
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem4 = new JMenuItem("About module...");
        jMenu2.add(jMenuItem4);
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JhoveWindow.this.showModuleInfo();
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem("About Jhove...");
        jMenu2.add(jMenuItem5);
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JhoveWindow.this.showAppInfo();
            }
        });
        this.setJMenuBar(jMenuBar);
    }

    private void setNormalBackground() {
        this.logo.setBackground(new Color(180, 255, 255));
    }

    private void setDragBackground() {
        this.logo.setBackground(new Color(180, 240, 140));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pickAndAnalyzeFile() {
        this._openFileItem.setEnabled(false);
        this._openURLItem.setEnabled(false);
        File file = null;
        String string = this.syncStr;
        synchronized (string) {
            JFileChooser jFileChooser = new JFileChooser();
            JhoveWindow.makeChooserOpaque(jFileChooser);
            if (this._lastDir != null) {
                jFileChooser.setCurrentDirectory(this._lastDir);
            }
            jFileChooser.setDialogTitle("Pick a file to analyze");
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) {
                this._openFileItem.setEnabled(true);
                this._openURLItem.setEnabled(true);
                return;
            }
            file = jFileChooser.getSelectedFile();
            this._lastDir = jFileChooser.getCurrentDirectory();
            ParseThread parseThread = new ParseThread(this);
            parseThread.setFile(file);
            parseThread.setModule(this.getSelectedModule());
            parseThread.start();
            this._base.setCurrentThread(parseThread);
        }
    }

    public static void makeChooserOpaque(JFileChooser jFileChooser) {
        jFileChooser.putClientProperty("JFileChooser.appBundleIsTraversable", "never");
        jFileChooser.putClientProperty("JFileChooser.packageIsTraversable", "never");
    }

    public void pickAndAnalyzeFile1(File file, Module module) {
        String string = file.getName();
        this._base.resetAbort();
        this._progWind.setDocName(string, false);
        this._progWind.setProgressState(2, false);
        this._progWind.setByteCount(-1L, true);
        this._progWind.show();
        try {
            ArrayList<File> arrayList = new ArrayList<File>(1);
            arrayList.add(file);
            this.openAndParse(arrayList, module);
        }
        catch (ThreadDeath threadDeath) {
            this._openFileItem.setEnabled(true);
            this._openURLItem.setEnabled(true);
            throw threadDeath;
        }
        this._openFileItem.setEnabled(true);
        this._openURLItem.setEnabled(true);
    }

    public void pickAndAnalyzeFileList1(List list, Module module) {
        if (list.isEmpty()) {
            return;
        }
        File file = (File)list.get(0);
        String string = file.getName();
        this._base.resetAbort();
        this._progWind.setDocName(string, false);
        this._progWind.setProgressState(2, false);
        this._progWind.setByteCount(-1L, true);
        this._progWind.show();
        try {
            this.openAndParse(list, module);
        }
        catch (ThreadDeath threadDeath) {
            this._openFileItem.setEnabled(true);
            this._openURLItem.setEnabled(true);
            throw threadDeath;
        }
        this._openFileItem.setEnabled(true);
        this._openURLItem.setEnabled(true);
    }

    public void analyzeDirectory(File file, Module module) {
        String[] stringArray = file.list(this.invisibleFilter);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2 == null) continue;
                if (file2.isDirectory()) {
                    this.analyzeDirectory(file2, module);
                    continue;
                }
                this.pickAndAnalyzeFile1(file2, module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pickAndAnalyzeURL() {
        this._openFileItem.setEnabled(false);
        this._openURLItem.setEnabled(false);
        String string = null;
        Object object = this.syncStr;
        synchronized (object) {
            String string2 = (String)JOptionPane.showInputDialog(this, "Choose a URL to analyze", "Select URL", -1, null, null, "http://");
            if (string2 == null) {
                this._openFileItem.setEnabled(true);
                this._openURLItem.setEnabled(true);
                return;
            }
            string = string2.trim();
        }
        object = new ParseThread(this);
        ((ParseThread)object).setURI(string);
        ((ParseThread)object).setModule(this.getSelectedModule());
        ((Thread)object).start();
    }

    public void pickAndAnalyzeURL1(String string, Module module) {
        this._progWind.setDocName(string.toString(), false);
        this._progWind.setProgressState(1, false);
        this._progWind.setContentLength(0L, false);
        this._progWind.setByteCount(0L, true);
        this._progWind.show();
        try {
            this._base.dispatch(this._app, module, null, this._viewHandler, null, new String[]{string});
        }
        catch (Exception exception) {
            this.reportError("Error processing URL", exception.getMessage());
        }
        this._progWind.hide();
        this._openFileItem.setEnabled(true);
        this._openURLItem.setEnabled(true);
    }

    @Override
    public int callback(int n, Object object) {
        switch (n) {
            case 1: {
                long l = (Long)object;
                this._progWind.setByteCount(l, true);
                break;
            }
            case 2: {
                String string = (String)object;
                if (string.length() > 48) {
                    string = "..." + string.substring(string.length() - 48, string.length());
                }
                this._progWind.setDocName(string, true);
                break;
            }
        }
        return 0;
    }

    public void setRawOutput(boolean bl) {
        this._rawOutput = bl;
    }

    public void setDoChecksum(boolean bl) {
        this._doChecksum = bl;
    }

    private void openAndParse(List list, Module module) {
        Object var3_3 = null;
        long l = 0L;
        String[] stringArray = new String[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            stringArray[n] = file.getAbsolutePath();
            if (!file.exists()) {
                this._progWind.hide();
                return;
            }
            if (!file.canRead()) {
                this._progWind.hide();
                this.reportError("File not readable", file.getName());
                return;
            }
            ++n;
        }
        this._base.setShowRawFlag(this._rawOutput);
        this._base.setChecksumFlag(this._doChecksum);
        try {
            this._base.dispatch(this._app, module, null, this._viewHandler, null, stringArray);
        }
        catch (Exception exception) {
            this._logger.warning(exception.toString());
        }
        this._progWind.hide();
    }

    private void openConfigWindow() {
        Object object;
        String string = this._base.getConfigFile();
        ConfigHandler configHandler = new ConfigHandler();
        XMLReader xMLReader = null;
        String string2 = this._base.getSaxClass();
        try {
            if (string2 != null) {
                xMLReader = XMLReaderFactory.createXMLReader(string2);
            } else {
                object = SAXParserFactory.newInstance();
                ((SAXParserFactory)object).setNamespaceAware(true);
                xMLReader = ((SAXParserFactory)object).newSAXParser().getXMLReader();
            }
            object = new File(string);
            String string3 = ((File)object).getCanonicalPath();
            String string4 = "file://";
            if (string3.charAt(0) != '/') {
                string4 = string4 + '/';
            }
            string4 = string4 + string3;
            xMLReader.setContentHandler(configHandler);
            xMLReader.setEntityResolver(configHandler);
            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            xMLReader.parse(string4);
        }
        catch (IOException iOException) {
            this.reportError("Config Error", "Cannot read configuration file");
            return;
        }
        catch (SAXException sAXException) {
            this.reportError("Config Error", "SAX parser not found: " + string2);
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.reportError("Config Error", "ParserConfigurationException");
        }
        object = new ConfigWindow(this, new File(string), configHandler);
        ((Window)object).setLocation(120, 40);
        ((Dialog)object).setVisible(true);
    }

    private void showModuleInfo() {
        Module module = this.getSelectedModule();
        if (this._moduleInfoWin == null) {
            this._moduleInfoWin = new ModuleInfoWindow(this._app, this._base, module);
            this._moduleInfoWin.setLocation(100, 90);
        } else {
            this._moduleInfoWin.showModule(module);
        }
        this._moduleInfoWin.setVisible(true);
    }

    private void showAppInfo() {
        if (this._appInfoWin == null) {
            this._appInfoWin = new AppInfoWindow(this._app, this._base);
            this._appInfoWin.setLocation(50, 45);
        }
        this._appInfoWin.show();
    }

    private Module getSelectedModule() {
        if (this._selectedModule.equals("")) {
            return null;
        }
        return (Module)this._base.getModuleMap().get(this._selectedModule.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportError(String string, String string2) {
        String string3 = this.syncStr;
        synchronized (string3) {
            JOptionPane.showMessageDialog(this, string2, string, 0);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (this.dataFlavorOK(dataFlavorArray)) {
            this.setDragBackground();
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setNormalBackground();
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
        if (this.dataFlavorOK(dataFlavorArray)) {
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                ParseThread parseThread = new ParseThread(this);
                parseThread.setFileList(list);
                parseThread.setModule(this.getSelectedModule());
                parseThread.start();
                this._base.setCurrentThread(parseThread);
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {
                dropTargetDropEvent.dropComplete(false);
                return;
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
        this.setNormalBackground();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    protected JMenuItem getCloseAllItem() {
        return this._closeAllItem;
    }

    private boolean dataFlavorOK(DataFlavor[] dataFlavorArray) {
        boolean bl = false;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
            return true;
        }
        return false;
    }

    protected class InvisibleFilenameFilter
    implements FilenameFilter {
        protected InvisibleFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return !string.startsWith(".");
        }
    }

    class ParseThread
    extends Thread {
        private JhoveWindow _win;
        private String _uri;
        private File _file;
        private List _fileList;
        private Module _module;

        protected ParseThread(JhoveWindow jhoveWindow2) {
            this._win = jhoveWindow2;
        }

        @Override
        public void run() {
            JhoveWindow.this._base.resetAbort();
            try {
                if (this._uri != null) {
                    this._win.pickAndAnalyzeURL1(this._uri, this._module);
                } else if (this._file != null) {
                    if (this._file.isDirectory()) {
                        JhoveWindow.this.analyzeDirectory(this._file, this._module);
                    } else {
                        this._win.pickAndAnalyzeFile1(this._file, this._module);
                    }
                } else if (this._fileList != null) {
                    this._win.pickAndAnalyzeFileList1(this._fileList, this._module);
                }
                JhoveWindow.this._base.setCurrentThread(null);
            }
            catch (ThreadDeath threadDeath) {
                JhoveWindow.this._progWind.hide();
                throw threadDeath;
            }
        }

        protected void setURI(String string) {
            this._uri = string;
        }

        protected void setFile(File file) {
            this._file = file;
        }

        protected void setFileList(List list) {
            this._fileList = list;
        }

        protected void setModule(Module module) {
            this._module = module;
        }
    }
}

