/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.viewer.JhoveWindow;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class JhoveView {
    private static final String NAME = "JhoveView";
    private static final int[] DATE = new int[]{2012, 9, 5};
    private static final String USAGE = null;
    private static final String RELEASE = "1.8b1";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String RIGHTS = "Derived from software Copyright 2004-2011 by the President and Fellows of Harvard College. Version 1.7 independently released. Released under the GNU Lesser General Public License.";
    private static final String CONFIG_PROPERTY = "edu.harvard.hul.ois.jhove.config";
    private static final String JHOVE_DIR = "jhove";
    private static final String CONFIG_DIR = "conf";
    private static final String SAX_PROPERTY = "edu.harvard.hul.ois.jhove.saxClass";
    private static final int ERROR = -1;
    private static final int INCOMPATIBLE_VM = -2;

    private JhoveView() {
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("java.vm.version");
        if (string.compareTo("1.4.0") < 0) {
            JhoveView.errorAlert("Java 1.4 or higher is required");
            System.exit(-2);
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        App app = new App(NAME, RELEASE, DATE, USAGE, RIGHTS);
        try {
            String string2 = JhoveBase.getConfigFileFromProperties();
            String string3 = JhoveBase.getSaxClassFromProperties();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (bl) {
                    int n = stringArray[i].length();
                    if (stringArray[i].charAt(n - 1) != '\"') continue;
                    bl = false;
                    continue;
                }
                if (stringArray[i].equals("-c")) {
                    if (i >= stringArray.length - 1) continue;
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-x")) {
                    if (i >= stringArray.length - 1) continue;
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].charAt(0) != '\"') continue;
                bl = true;
            }
            JhoveBase jhoveBase = new JhoveBase();
            try {
                jhoveBase.init(string2, string3);
            }
            catch (JhoveException jhoveException) {
                JhoveView.errorAlert(jhoveException.getMessage());
            }
            JhoveWindow jhoveWindow = new JhoveWindow(app, jhoveBase);
            jhoveWindow.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private static void errorAlert(String string) {
        JFrame jFrame = new JFrame();
        if (string.length() > 80) {
            string = string.substring(0, 79) + "...";
        }
        JOptionPane.showMessageDialog(jFrame, string, "Jhove Error", 0);
    }
}

