/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.AsciiModule;
import edu.harvard.hul.ois.jhove.module.GifModule;
import edu.harvard.hul.ois.jhove.module.HtmlModule;
import edu.harvard.hul.ois.jhove.module.Jpeg2000Module;
import edu.harvard.hul.ois.jhove.module.JpegModule;
import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.TiffModule;
import edu.harvard.hul.ois.jhove.module.Utf8Module;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.XmlModule;
import edu.harvard.hul.ois.jhove.viewer.ConfigWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class DefaultConfigurationBuilder {
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String HOME_DIR = System.getProperty("user.home");
    private static final String JHOVE_DIR = HOME_DIR + FILE_SEP + "jhove";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private File configFile;
    private Class<?>[] builtInModules = new Class[]{AiffModule.class, AsciiModule.class, GifModule.class, HtmlModule.class, Jpeg2000Module.class, JpegModule.class, PdfModule.class, TiffModule.class, Utf8Module.class, WaveModule.class, XmlModule.class};

    public DefaultConfigurationBuilder(File file) {
        this.configFile = file != null ? file : new File(JHOVE_DIR + FILE_SEP + "conf" + FILE_SEP + "jhove.conf");
    }

    public void writeDefaultConfigFile() throws IOException {
        ConfigWriter configWriter = new ConfigWriter(this.configFile, null);
        List<ConfigWriter.ModuleInfo> list = this.getModules();
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(JHOVE_DIR);
        File file2 = new File(TEMP_DIR);
        configWriter.writeFile(list, arrayList, file, file2, DEFAULT_ENCODING, 131072);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    protected List<ConfigWriter.ModuleInfo> getModules() {
        int n = this.builtInModules.length;
        ArrayList<ConfigWriter.ModuleInfo> arrayList = new ArrayList<ConfigWriter.ModuleInfo>(n);
        try {
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = this.builtInModules[i];
                ConfigWriter.ModuleInfo moduleInfo = new ConfigWriter.ModuleInfo(clazz.getName());
                moduleInfo.init = null;
                moduleInfo.params = this.getDefaultConfigParameters(clazz);
                arrayList.add(moduleInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    protected String[] getDefaultConfigParameters(Class<?> clazz) {
        try {
            Field field = clazz.getField("defaultConfigParams");
            return (String[])field.get(null);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }
}

