/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.RFC1766Lang;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfProfile;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.PdfXMPSource;
import edu.harvard.hul.ois.jhove.module.pdf.TaggedProfile;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class AProfile
extends PdfProfile {
    private TaggedProfile _taggedProfile;
    private boolean _levelA;
    private boolean hasDevRGB;
    private boolean hasDevCMYK;
    private boolean hasUncalCS;
    private String[] annotTypes = new String[]{"Text", "Link", "FreeText", "Line", "Square", "Circle", "Polygon", "Polyline", "Highlight", "Underline", "Squiggly", "StrikeOut", "Stamp", "Caret", "Ink", "Popup", "Widget", "Screen", "PrinterMark", "TrapNet"};
    private String[] nonTextAnnotTypes = new String[]{"Link", "Line", "Square", "Circle", "Polygon", "Polyline", "Stamp", "Caret", "Ink", "Popup", "Widget", "Screen", "PrinterMark", "TrapNet"};
    private String[] excludedActions = new String[]{"Launch", "Sound", "Movie", "ResetForm", "ImportData", "JavaScript", "set-state", "no-op"};
    private String[] excludedFilters = new String[]{"LZWDecode"};

    public AProfile(PdfModule pdfModule) {
        super(pdfModule);
        this._profileText = "ISO PDF/A-1, Level B";
    }

    public void setTaggedProfile(TaggedProfile taggedProfile) {
        this._taggedProfile = taggedProfile;
    }

    @Override
    public boolean satisfiesThisProfile() {
        this._levelA = true;
        if (!this._module.mayBePDFACompliant()) {
            this._levelA = false;
            return false;
        }
        if (this._taggedProfile != null && !this._taggedProfile.isAlreadyOK()) {
            this._levelA = false;
        }
        this.hasDevCMYK = false;
        this.hasDevRGB = false;
        this.hasUncalCS = false;
        try {
            if (!(this._module.getEncryptionDict() == null && this.trailerDictOK() && this.catalogOK() && this.resourcesOK() && this.fontsOK() && this.outlinesOK())) {
                this._levelA = false;
                return false;
            }
        }
        catch (Exception exception) {
            this._levelA = false;
            return false;
        }
        return true;
    }

    protected boolean satisfiesLevelA() {
        return this._levelA;
    }

    private boolean trailerDictOK() {
        PdfDictionary pdfDictionary = this._module.getTrailerDict();
        if (pdfDictionary == null) {
            return false;
        }
        try {
            if (pdfDictionary.get("Encrypt") != null) {
                return false;
            }
            if (pdfDictionary.get("ID") == null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean catalogOK() {
        PdfDictionary pdfDictionary = this._module.getCatalogDict();
        if (pdfDictionary == null) {
            return false;
        }
        try {
            Object object;
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Lang");
            if (pdfSimpleObject != null && !((RFC1766Lang)(object = new RFC1766Lang(pdfSimpleObject.getStringValue()))).isSyntaxCorrect()) {
                return false;
            }
            object = (PdfStream)this._module.resolveIndirectObject(pdfDictionary.get("Metadata"));
            if (!this.metadataOK((PdfStream)object)) {
                return false;
            }
            PdfDictionary pdfDictionary2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("AcroForm"));
            if (pdfDictionary2 != null && !this.formOK(pdfDictionary2)) {
                return false;
            }
            if (pdfDictionary.get("AA") != null || pdfDictionary.get("OCProperties") != null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean fontsOK() {
        if (!this.type0FontsOK()) {
            return false;
        }
        List<Map<Integer, PdfObject>> list = this._module.getFontMaps();
        ListIterator<Map<Integer, PdfObject>> listIterator = list.listIterator();
        try {
            while (listIterator.hasNext()) {
                Map map = (Map)listIterator.next();
                for (PdfDictionary pdfDictionary : map.values()) {
                    if (this.fontOK(pdfDictionary)) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean fontOK(PdfDictionary pdfDictionary) {
        try {
            Object object;
            PdfObject pdfObject;
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Subtype");
            String string = pdfSimpleObject.getStringValue();
            PdfDictionary pdfDictionary2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("FontDescriptor"));
            PdfSimpleObject pdfSimpleObject2 = null;
            if (pdfDictionary2 != null) {
                pdfSimpleObject2 = (PdfSimpleObject)this._module.resolveIndirectObject(pdfDictionary2.get("Flags"));
            }
            int n = 0;
            if (pdfSimpleObject2 != null) {
                n = pdfSimpleObject2.getIntValue();
            }
            if ("Type1".equals(string)) {
                if (pdfDictionary2 == null) {
                    return false;
                }
                return pdfDictionary2.get("CharSet") != null;
            }
            if ("Type0".equals(string) && (pdfObject = pdfDictionary.get("Ordering")) instanceof PdfSimpleObject) {
                try {
                    object = ((PdfSimpleObject)pdfObject).getStringValue();
                    if ("Adobe-GB1".equals(object) || "Adobe-CNS1".equals(object) || "Adobe-Japan1".equals(object) || "Adobe-Korea1".equals(object)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((pdfObject = pdfDictionary.get("Encoding")) instanceof PdfSimpleObject) {
                if ((n & 4) != 0) {
                    return false;
                }
                object = ((PdfSimpleObject)pdfObject).getStringValue();
                if ("WinAnsiEncoding".equals(object) || "MacRomanDecoding".equals(object) || "MacExpertDecoding".equals(object)) {
                    return true;
                }
            }
            if ((object = pdfDictionary.get("ToUnicode")) == null) {
                this._levelA = false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean type0FontsOK() {
        Map<Integer, PdfObject> map = this._module.getFontMap(1);
        if (map == null) {
            return true;
        }
        try {
            Iterator<PdfObject> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Vector vector;
                PdfObject pdfObject;
                PdfDictionary pdfDictionary;
                PdfSimpleObject pdfSimpleObject;
                PdfSimpleObject pdfSimpleObject2;
                PdfObject pdfObject2;
                String string = null;
                String string2 = null;
                PdfDictionary pdfDictionary2 = (PdfDictionary)iterator.next();
                PdfObject pdfObject3 = pdfDictionary2.get("Encoding");
                if (pdfObject3 instanceof PdfDictionary) {
                    pdfObject2 = (PdfDictionary)this._module.resolveIndirectObject(((PdfDictionary)pdfObject3).get("CIDSystemInfo"));
                    pdfSimpleObject2 = (PdfSimpleObject)((PdfDictionary)pdfObject2).get("Registry");
                    string = pdfSimpleObject2.getStringValue();
                    pdfSimpleObject2 = (PdfSimpleObject)((PdfDictionary)pdfObject2).get("Ordering");
                    string2 = pdfSimpleObject2.getStringValue();
                }
                if (!(pdfSimpleObject = (PdfSimpleObject)(pdfDictionary = (PdfDictionary)this._module.resolveIndirectObject(pdfObject = (PdfObject)(vector = ((PdfArray)(pdfObject2 = (PdfArray)this._module.resolveIndirectObject(pdfDictionary2.get("DescendantFonts")))).getContent()).elementAt(0))).get("Subtype")).getStringValue().equals("CIDFontType0") && !pdfSimpleObject.getStringValue().equals("CIDFontType2")) {
                    return false;
                }
                PdfDictionary pdfDictionary3 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("CIDSystemInfo"));
                pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary3.get("Registry");
                String string3 = pdfSimpleObject2.getStringValue();
                if (string == null) {
                    string = string3;
                } else if (!string.equals(string3)) {
                    return false;
                }
                pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary3.get("Ordering");
                string3 = pdfSimpleObject2.getStringValue();
                if (string2 == null) {
                    string2 = string3;
                } else if (!string2.equals(string3)) {
                    return false;
                }
                if (!"CIDFontType2".equals(pdfSimpleObject.getStringValue())) continue;
                PdfObject pdfObject4 = pdfDictionary.get("CIDToGIDMap");
                if (pdfObject4 == null) {
                    return false;
                }
                PdfObject pdfObject5 = pdfObject4 instanceof PdfIndirectObj ? this._module.resolveIndirectObject(pdfObject4) : pdfObject4;
                if (!(pdfObject5 instanceof PdfSimpleObject ? !"Identity".equals(((PdfSimpleObject)pdfObject5).getStringValue()) : !(pdfObject5 instanceof PdfStream))) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean ttFontEncodingOK(PdfDictionary pdfDictionary) {
        try {
            PdfSimpleObject pdfSimpleObject;
            String string;
            PdfDictionary pdfDictionary2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("FontDescriptor"));
            if (pdfDictionary2 == null) {
                return true;
            }
            PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary2.get("Flags");
            int n = pdfSimpleObject2.getIntValue();
            if ((n & 4) == 0 && !"MacRomanEncoding".equals(string = (pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Encoding")).getStringValue()) && !"WinAnsiEncoding".equals(string)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean formOK(PdfDictionary pdfDictionary) {
        try {
            PdfArray pdfArray = (PdfArray)pdfDictionary.get("Fields");
            Vector vector = pdfArray.getContent();
            for (int i = 0; i < vector.size(); ++i) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)vector.elementAt(i);
                if (this.fieldOK(pdfDictionary2)) continue;
                return false;
            }
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("NeedAppearances");
            if (pdfSimpleObject != null && !pdfSimpleObject.isFalse()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean fieldOK(PdfDictionary pdfDictionary) {
        try {
            if (pdfDictionary.get("AA") != null) {
                return false;
            }
            if (pdfDictionary.get("A") != null) {
                return false;
            }
            if (pdfDictionary.get("DR") == null) {
                return false;
            }
            PdfArray pdfArray = (PdfArray)pdfDictionary.get("Kids");
            if (pdfArray != null) {
                Vector vector = pdfArray.getContent();
                for (int i = 0; i < vector.size(); ++i) {
                    PdfDictionary pdfDictionary2 = (PdfDictionary)vector.elementAt(i);
                    if (pdfDictionary2.get("Parent") == null || this.fieldOK(pdfDictionary2)) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean resourcesOK() {
        PageTreeNode pageTreeNode = this._module.getDocumentTree();
        try {
            DocNode docNode;
            pageTreeNode.startWalk();
            while ((docNode = pageTreeNode.nextDocNode()) != null) {
                Object object;
                PdfObject pdfObject;
                PdfDictionary pdfDictionary;
                Object object2;
                Object object3;
                Object object4;
                PdfDictionary pdfDictionary2 = docNode.getResources();
                if (pdfDictionary2 != null) {
                    object4 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("ColorSpace"));
                    if (!this.colorSpaceOK((PdfDictionary)object4)) {
                        return false;
                    }
                    object3 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("ExtGState"));
                    if (!this.extGStateOK((PdfDictionary)object3)) {
                        return false;
                    }
                    object2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("XObject"));
                    if (!this.xObjectsOK((PdfDictionary)object2)) {
                        return false;
                    }
                }
                if (!(docNode instanceof PageObject)) continue;
                object4 = ((PageObject)docNode).getContentStreams();
                if (object4 != null) {
                    object3 = object4.listIterator();
                    while (object3.hasNext()) {
                        object2 = (PdfStream)object3.next();
                        PdfDictionary pdfDictionary3 = ((PdfStream)object2).getDict();
                        pdfDictionary = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary3.get("Resources"));
                        if (pdfDictionary != null) {
                            pdfObject = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("ColorSpace"));
                            if (!this.colorSpaceOK((PdfDictionary)pdfObject)) {
                                return false;
                            }
                            object = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("ExtGState"));
                            if (!this.extGStateOK((PdfDictionary)object)) {
                                return false;
                            }
                            PdfDictionary pdfDictionary4 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("XObject"));
                            if (!this.xObjectsOK(pdfDictionary4)) {
                                return false;
                            }
                        }
                        if (!this.hasFilters(pdfObject = pdfDictionary3.get("Filter"), this.excludedFilters)) continue;
                        return false;
                    }
                }
                if ((object3 = ((PageObject)docNode).getAnnotations()) == null) continue;
                object2 = ((PdfArray)object3).getContent();
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    double d;
                    pdfDictionary = (PdfDictionary)this._module.resolveIndirectObject((PdfObject)((Vector)object2).elementAt(i));
                    pdfObject = (PdfSimpleObject)pdfDictionary.get("Subtype");
                    object = ((PdfSimpleObject)pdfObject).getStringValue();
                    boolean bl = false;
                    for (int j = 0; j < this.annotTypes.length; ++j) {
                        if (!this.annotTypes[j].equals(object)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return false;
                    }
                    if ("Widget".equals(object) && pdfDictionary.get("AA") != null) {
                        return false;
                    }
                    PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("CA");
                    if (pdfSimpleObject == null || (d = pdfSimpleObject.getDoubleValue()) == 1.0) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean colorSpaceOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return true;
        }
        Iterator iterator = pdfDictionary.iterator();
        while (iterator.hasNext()) {
            PdfObject pdfObject = (PdfObject)iterator.next();
            if (!(pdfObject instanceof PdfArray)) continue;
            Vector vector = ((PdfArray)pdfObject).getContent();
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)vector.elementAt(0);
            String string = pdfSimpleObject.getStringValue();
            boolean bl = this.hasUncalCS;
            if ("DeviceCMYK".equals(string)) {
                this.hasDevCMYK = true;
                this.hasUncalCS = true;
            } else if ("DeviceRGB".equals(string)) {
                this.hasDevRGB = true;
                this.hasUncalCS = true;
            } else if ("DeviceGray".equals(string)) {
                this.hasUncalCS = true;
            }
            if (this.hasUncalCS && !bl && !this.checkUncalIntent()) {
                return false;
            }
            if (!this.hasDevRGB || !this.hasDevCMYK) continue;
            return false;
        }
        return true;
    }

    private boolean checkUncalIntent() {
        try {
            PdfDictionary pdfDictionary = this._module.getCatalogDict();
            PdfArray pdfArray = (PdfArray)this._module.resolveIndirectObject(pdfDictionary.get("OutputIntents"));
            if (pdfArray == null) {
                return false;
            }
            Vector vector = pdfArray.getContent();
            PdfStream pdfStream = null;
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                PdfSimpleObject pdfSimpleObject;
                PdfStream pdfStream2;
                PdfDictionary pdfDictionary2 = (PdfDictionary)vector.elementAt(0);
                PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary2.get("OutputCondition");
                if (pdfSimpleObject2 == null || (pdfStream2 = (PdfStream)this._module.resolveIndirectObject(pdfDictionary2.get("DestOutputProfile"))) == null) continue;
                if (pdfStream != null) {
                    if (pdfStream2 != pdfStream) {
                        return false;
                    }
                } else {
                    pdfStream = pdfStream2;
                }
                if ((pdfSimpleObject = (PdfSimpleObject)pdfDictionary2.get("S")) == null || !"GTS_PDFA1".equals(pdfSimpleObject.getStringValue())) continue;
                bl = true;
            }
            if (pdfStream == null || !bl) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean outlinesOK() {
        if (!this._module.getActionsExist()) {
            return true;
        }
        PdfDictionary pdfDictionary = this._module.getOutlineDict();
        if (pdfDictionary == null) {
            return true;
        }
        try {
            PdfDictionary pdfDictionary2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("First"));
            while (pdfDictionary2 != null) {
                if (!this.checkOutlineItem(pdfDictionary2)) {
                    return false;
                }
                pdfDictionary2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("Next"));
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean checkOutlineItem(PdfDictionary pdfDictionary) {
        try {
            PdfDictionary pdfDictionary2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("A"));
            if (pdfDictionary2 != null && !this.actionOK(pdfDictionary2)) {
                return false;
            }
            PdfDictionary pdfDictionary3 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("First"));
            while (pdfDictionary3 != null) {
                if (!this.checkOutlineItem(pdfDictionary3)) {
                    return false;
                }
                pdfDictionary3 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary3.get("Next"));
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean actionOK(PdfDictionary pdfDictionary) {
        try {
            int n;
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("S");
            String string = pdfSimpleObject.getStringValue();
            for (n = 0; n < this.excludedActions.length; ++n) {
                if (!this.excludedActions[n].equals(string)) continue;
                return false;
            }
            PdfObject pdfObject = pdfDictionary.get("Next");
            if (pdfObject instanceof PdfDictionary) {
                if (!this.actionOK((PdfDictionary)pdfObject)) {
                    return false;
                }
            } else if (pdfObject instanceof PdfArray) {
                Vector vector = ((PdfArray)pdfObject).getContent();
                for (n = 0; n < vector.size(); ++n) {
                    PdfDictionary pdfDictionary2 = (PdfDictionary)vector.elementAt(n);
                    if (this.actionOK(pdfDictionary2)) continue;
                    return false;
                }
            } else if (pdfObject != null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean extGStateOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return true;
        }
        try {
            double d;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            PdfObject pdfObject = pdfDictionary.get("TR");
            PdfObject pdfObject2 = pdfDictionary.get("TR2");
            if (pdfObject != null) {
                return false;
            }
            if (pdfObject2 != null && !"Default".equals(object4 = ((PdfSimpleObject)pdfObject2).getStringValue())) {
                return false;
            }
            object4 = (PdfSimpleObject)pdfDictionary.get("RI");
            if (object4 != null && !this.validIntentString((String)(object3 = ((PdfSimpleObject)object4).getStringValue()))) {
                return false;
            }
            object3 = (PdfSimpleObject)pdfDictionary.get("SMask");
            if (object3 != null && !"None".equals(object2 = ((PdfSimpleObject)object3).getStringValue())) {
                return false;
            }
            object2 = (PdfSimpleObject)pdfDictionary.get("BM");
            if (object2 != null && !"Normal".equals(object = ((PdfSimpleObject)object2).getStringValue()) && !"Compatible".equals(object)) {
                return false;
            }
            object = (PdfSimpleObject)pdfDictionary.get("CA");
            if (object != null && (d = ((PdfSimpleObject)object).getDoubleValue()) != 1.0) {
                return false;
            }
            object = (PdfSimpleObject)pdfDictionary.get("ca");
            if (object != null && (d = ((PdfSimpleObject)object).getDoubleValue()) != 1.0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean xObjectOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return true;
        }
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Subtype");
            if (pdfSimpleObject != null) {
                String string = pdfSimpleObject.getStringValue();
                if ("PS".equals(string)) {
                    return false;
                }
                if ("Image".equals(string) && !this.imageObjectOK(pdfDictionary)) {
                    return false;
                }
                if ("Form".equals(string) && !this.formObjectOK(pdfDictionary)) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean formObjectOK(PdfDictionary pdfDictionary) {
        return pdfDictionary.get("OPI") == null && pdfDictionary.get("Ref") == null;
    }

    protected boolean imageObjectOK(PdfDictionary pdfDictionary) {
        try {
            String string;
            if (pdfDictionary.get("OPI") != null || pdfDictionary.get("Alternates") != null) {
                return false;
            }
            PdfObject pdfObject = pdfDictionary.get("Filter");
            if (this.hasFilters(pdfObject, this.excludedFilters)) {
                return false;
            }
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Interpolate");
            if (pdfSimpleObject != null && !pdfSimpleObject.isFalse()) {
                return false;
            }
            PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary.get("Intent");
            if (pdfSimpleObject2 != null && !this.validIntentString(string = pdfSimpleObject2.getStringValue())) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean validIntentString(String string) {
        return "RelativeColorimetric".equals(string) || "AbsoluteColorimetric".equals(string) || "Perceptual".equals(string) || "Saturation".equals(string);
    }

    private boolean metadataOK(PdfStream pdfStream) {
        if (pdfStream == null) {
            return false;
        }
        try {
            PdfDictionary pdfDictionary = pdfStream.getDict();
            if (pdfDictionary.get("Filter") != null) {
                return false;
            }
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            PdfXMPSource pdfXMPSource = new PdfXMPSource(pdfStream, this._module.getFile());
            XMPHandler xMPHandler = new XMPHandler();
            xMLReader.setContentHandler(xMPHandler);
            xMLReader.setErrorHandler(xMPHandler);
            try {
                xMLReader.parse(pdfXMPSource);
                if (!xMPHandler.isPdfaCompliant()) {
                    return false;
                }
            }
            catch (SAXException sAXException) {
                String string = sAXException.getMessage();
                if (string != null && string.startsWith("ENC=")) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

