/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.pdf.AProfile;
import edu.harvard.hul.ois.jhove.module.pdf.AProfileLevelA;
import edu.harvard.hul.ois.jhove.module.pdf.Comment;
import edu.harvard.hul.ois.jhove.module.pdf.CrossRefStream;
import edu.harvard.hul.ois.jhove.module.pdf.Destination;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryStart;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.FileTokenizer;
import edu.harvard.hul.ois.jhove.module.pdf.Filter;
import edu.harvard.hul.ois.jhove.module.pdf.Keyword;
import edu.harvard.hul.ois.jhove.module.pdf.LinearizedProfile;
import edu.harvard.hul.ois.jhove.module.pdf.Literal;
import edu.harvard.hul.ois.jhove.module.pdf.Name;
import edu.harvard.hul.ois.jhove.module.pdf.NameTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.ObjectStream;
import edu.harvard.hul.ois.jhove.module.pdf.PageLabelNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.Parser;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfProfile;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStrings;
import edu.harvard.hul.ois.jhove.module.pdf.PdfXMPSource;
import edu.harvard.hul.ois.jhove.module.pdf.StringValuedToken;
import edu.harvard.hul.ois.jhove.module.pdf.TaggedProfile;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import edu.harvard.hul.ois.jhove.module.pdf.X1Profile;
import edu.harvard.hul.ois.jhove.module.pdf.X1aProfile;
import edu.harvard.hul.ois.jhove.module.pdf.X2Profile;
import edu.harvard.hul.ois.jhove.module.pdf.X3Profile;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PdfModule
extends ModuleBase {
    private static final String NAME = "PDF-hul";
    private static final String RELEASE = "1.7";
    private static final int[] DATE = new int[]{2012, 8, 12};
    private static final String[] FORMAT = new String[]{"PDF", "Portable Document Format"};
    private static final String COVERAGE = "PDF 1.0-1.6; PDF/X-1 (ISO 15930-1:2001), X-1a (ISO 15930-4:2003), X-2 (ISO 15930-5:2003), and X-3 (ISO 15930-6:2003); Tagged PDF; Linearized PDF; PDF/A (ISO/CD 19005-1)";
    private static final String[] MIMETYPE = new String[]{"application/pdf"};
    private static final String WELLFORMED = "A PDF file is well-formed if it meets the criteria defined in Chapter 3 of the PDF Reference 1.6 (5th edition, 2004)";
    private static final String VALIDITY = null;
    private static final String REPINFO = null;
    private static final String NOTE = "This module does *not* validate data within content streams (including operators) or encrypted data";
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    private static final String ENCRYPTED = "<May be encrypted>";
    public static final int F_TYPE0 = 1;
    public static final int F_TYPE1 = 2;
    public static final int F_TT = 3;
    public static final int F_TYPE3 = 4;
    public static final int F_MM1 = 5;
    public static final int F_CID0 = 6;
    public static final int F_CID2 = 7;
    protected int DEFAULT_MAX_FONTS = 1000;
    private static final int EOFSCANSIZE = 1024;
    private static final int XREFSCANSIZE = 128;
    protected RandomAccessFile _raf;
    protected Parser _parser;
    protected String _version;
    protected Property _metadata;
    protected Property _xmpProp;
    protected long _eof;
    protected long _startxref;
    protected long _prevxref;
    protected int _numFreeObjects;
    protected Property _idProperty;
    protected int _objCount;
    protected int _numObjects;
    protected int _numTrailers;
    protected Map _objects;
    protected long[] _xref;
    protected int[][] _xref2;
    protected boolean _xrefIsStream;
    protected boolean _encrypted;
    protected List<Property> _docCatalogList;
    protected List<Property> _encryptList;
    protected List<Property> _docInfoList;
    protected List<Property> _extStreamsList;
    protected List<Property> _imagesList;
    protected List<Property> _filtersList;
    protected List<Property> _pagesList;
    protected Map<Integer, PdfObject> _type0FontsMap;
    protected Map<Integer, PdfObject> _type1FontsMap;
    protected Map<Integer, PdfObject> _mmFontsMap;
    protected Map<Integer, PdfObject> _type3FontsMap;
    protected Map<Integer, PdfObject> _trueTypeFontsMap;
    protected Map<Integer, PdfObject> _cid0FontsMap;
    protected Map<Integer, PdfObject> _cid2FontsMap;
    protected Map<Integer, Integer> _pageSeqMap;
    protected PdfIndirectObj _docCatDictRef;
    protected PdfIndirectObj _encryptDictRef;
    protected PdfIndirectObj _docInfoDictRef;
    protected PdfIndirectObj _pagesDictRef;
    protected PdfDictionary _docCatDict;
    protected PdfDictionary _docInfoDict;
    protected PageTreeNode _docTreeRoot;
    protected PdfDictionary _pageLabelDict;
    protected PageLabelNode _pageLabelRoot;
    protected NameTreeNode _embeddedFiles;
    protected NameTreeNode _destNames;
    protected PdfDictionary _encryptDict;
    protected PdfDictionary _trailerDict;
    protected PdfDictionary _viewPrefDict;
    protected PdfDictionary _outlineDict;
    protected PdfDictionary _destsDict;
    protected boolean _showFonts;
    protected boolean _showOutlines;
    protected boolean _showAnnotations;
    protected boolean _showPages;
    protected boolean _actionsExist;
    protected boolean _pdfACompliant;
    protected boolean _recursionWarned;
    protected boolean _skippedFontsReported;
    protected boolean _skippedOutlinesReported;
    protected boolean _skippedAnnotationsReported;
    protected boolean _skippedPagesReported;
    protected List<PdfProfile> _profile;
    protected ObjectStream _cachedObjectStream;
    protected int _cachedStreamIndex;
    protected Set<Integer> _visitedOutlineNodes;
    protected int maxFonts;
    protected int _nFonts;
    private static final String fontsSkippedString = "Fonts exist, but are not displayed; to display remove param value of f from the config file";
    private static final String outlinesSkippedString = "Outlines exist, but are not displayed; to display remove param value of o from the config file";
    private static final String annotationsSkippedString = "Annotations exist, but are not displayed; to display remove param value of a from the config file";
    private static final String pagesSkippedString = "Page information is not displayed; to display remove param value of p from the config file";
    protected static final String outlinesRecursiveString = "Outlines contain recursive references.";
    private static final String[] compressionStrings = new String[]{"LZWDecode", "RunLengthDecode", "DCTDecode", "CCITTFaxDecode"};
    private static final int[] compressionValues = new int[]{5, 32773, 6, 2};
    private static final String[] colorSpaceStrings = new String[]{"Lab", "DeviceRGB", "DeviceCMYK", "DeviceGray", "Indexed"};
    private static final int[] colorSpaceValues = new int[]{8, 2, 5, 1, 3};

    public PdfModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, true);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
        Document document = new Document("PDF Reference: Adobe Portable Document Format, Version 1.4", DocumentType.BOOK);
        agent = new Agent("Adobe Systems, Inc.", AgentType.COMMERCIAL);
        agent.setAddress("345 Park Avenue, San Jose, California 95110-2704");
        agent.setTelephone("+1 (408) 536-6000");
        agent.setFax("+1 (408) 537-6000");
        agent.setWeb("http://www.adobe.com/");
        document.setPublisher(agent);
        document.setDate("2001-12");
        document.setEdition("3rd edition");
        document.setIdentifier(new Identifier("0-201-75839-3", IdentifierType.ISBN));
        document.setIdentifier(new Identifier("http://partners.adobe.com/asn/acrobat/docs/File_Format_Specifications/PDFReference.pdf", IdentifierType.URL));
        this._specification.add(document);
        document = new Document("PDF Reference: Adobe Portable Document Format, Version 1.5", DocumentType.BOOK);
        document.setPublisher(agent);
        document.setDate("2003");
        document.setEdition("4th edition");
        document.setIdentifier(new Identifier("http://partners.adobe.com/public/developer/en/pdf/PDFReference15_v6.pdf", IdentifierType.URL));
        this._specification.add(document);
        document = new Document("PDF Reference: Adobe Portable Document Format, Version 1.6", DocumentType.BOOK);
        document.setPublisher(agent);
        document.setDate("2004-11");
        document.setEdition("5th edition");
        document.setIdentifier(new Identifier("http://partners.adobe.com/public/developer/en/pdf/PDFReference16.pdf", IdentifierType.URL));
        this._specification.add(document);
        document = new Document("Graphic technology -- Prepress digital data exchange -- Use of PDF -- Part 1: Complete exchange using CMYK data (PDF/X-1 and PDF/X-1a)", DocumentType.STANDARD);
        Agent agent2 = new Agent("ISO", AgentType.STANDARD);
        agent2.setAddress("1, rue de Varembe, Casa postale 56, CH-1211, Geneva 20, Switzerland");
        agent2.setTelephone("+41 22 749 01 11");
        agent2.setFax("+41 22 733 34 30");
        agent2.setEmail("iso@iso.ch");
        agent2.setWeb("http://www.iso.org");
        document.setPublisher(agent2);
        document.setDate("2001-12-06");
        document.setIdentifier(new Identifier("ISO 15930-1:2001", IdentifierType.ISO));
        this._specification.add(document);
        document = new Document("Graphic technology -- Prepress digital data exchange -- Use of PDF -- Part 4: Complete exchange using CMYK and spot colour printing data using PDF 1.4 (PDF/X-1a)", DocumentType.STANDARD);
        document.setPublisher(agent2);
        document.setDate("2003-08-04");
        document.setIdentifier(new Identifier("ISO 15930-4:2003", IdentifierType.ISO));
        this._specification.add(document);
        document = new Document("Graphic technology -- Prepress digital data exchange -- Use of PDF -- Part 5: Partial exchange of printing data using PDF 1.4 (PDF/X-2)", DocumentType.STANDARD);
        document.setPublisher(agent2);
        document.setDate("2003-08-05");
        document.setIdentifier(new Identifier("ISO 15930-5:2003", IdentifierType.ISO));
        this._specification.add(document);
        document = new Document("Graphic technology -- Prepress digital data exchange -- Use of PDF -- Part 6: Complete exchange suitable for colour-managed workflows using PDF 1.4 (PDF/X-3)", DocumentType.STANDARD);
        document.setPublisher(agent2);
        document.setDate("2003-08-06");
        document.setIdentifier(new Identifier("ISO 15930-6:2003", IdentifierType.ISO));
        this._specification.add(document);
        this._signature.add(new ExternalSignature(".pdf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL));
        this._signature.add(new InternalSignature("%PDF-1.", SignatureType.MAGIC, SignatureUseType.MANDATORY, 0));
        document = new Document("Document management -- Electronic document file format for long-term preservation -- Part 1: Use of PDF (PDF/A)", DocumentType.RFC);
        document.setPublisher(agent2);
        document.setDate("2003-11-30");
        document.setIdentifier(new Identifier("ISO/CD 19005-1", IdentifierType.ISO));
        document.setIdentifier(new Identifier("http://www.aiim.org/documents/standards/ISO_19005-1_(E).doc", IdentifierType.URL));
        this._specification.add(document);
        this._profile = new ArrayList<PdfProfile>(6);
        this._profile.add(new LinearizedProfile(this));
        TaggedProfile taggedProfile = new TaggedProfile(this);
        this._profile.add(taggedProfile);
        AProfile aProfile = new AProfile(this);
        this._profile.add(aProfile);
        aProfile.setTaggedProfile(taggedProfile);
        AProfileLevelA aProfileLevelA = new AProfileLevelA(this);
        this._profile.add(aProfileLevelA);
        aProfileLevelA.setAProfile(aProfile);
        X1Profile x1Profile = new X1Profile(this);
        this._profile.add(x1Profile);
        X1aProfile x1aProfile = new X1aProfile(this);
        this._profile.add(x1aProfile);
        x1aProfile.setX1Profile(x1Profile);
        this._profile.add(new X2Profile(this));
        this._profile.add(new X3Profile(this));
        this._showAnnotations = false;
        this._showFonts = false;
        this._showOutlines = false;
        this._showPages = false;
        this.maxFonts = this.DEFAULT_MAX_FONTS;
    }

    public void resetParams() throws Exception {
        this._showAnnotations = true;
        this._showFonts = true;
        this._showOutlines = true;
        this._showPages = true;
        this.maxFonts = this.DEFAULT_MAX_FONTS;
    }

    public void param(String string) {
        if (string != null) {
            if ((string = string.toLowerCase()).indexOf(97) >= 0) {
                this._showAnnotations = false;
            }
            if (string.indexOf(102) >= 0) {
                this._showFonts = false;
            }
            if (string.indexOf(111) >= 0) {
                this._showOutlines = false;
            }
            if (string.indexOf(112) >= 0) {
                this._showPages = false;
            }
            if (string.indexOf(110) >= 0) {
                char c;
                int n;
                int n2 = string.indexOf(110);
                StringBuffer stringBuffer = new StringBuffer();
                for (n = n2 + 1; n < string.length() && Character.isDigit(c = string.charAt(n)); ++n) {
                    stringBuffer.append(c);
                }
                try {
                    n = Integer.parseInt(stringBuffer.toString());
                    if (n > 0) {
                        this.maxFonts = n;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public final void parse(RandomAccessFile randomAccessFile, RepInfo repInfo) throws IOException {
        this.initParse();
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule((Module)this);
        this._objects = new HashMap();
        this._raf = randomAccessFile;
        FileTokenizer fileTokenizer = new FileTokenizer(this._raf);
        this._parser = new Parser(fileTokenizer);
        this._parser.setObjectMap(this._objects);
        ArrayList<Property> arrayList = new ArrayList<Property>(11);
        this._metadata = new Property("PDFMetadata", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        if (this._raf.length() > 10000000000L) {
            this._pdfACompliant = false;
        }
        if (!this.parseHeader(repInfo)) {
            return;
        }
        if (!this.findLastTrailer(repInfo)) {
            return;
        }
        this._prevxref = -1L;
        boolean bl = true;
        while (this._startxref > 0L) {
            if (!this.parseTrailer(repInfo, !bl)) {
                return;
            }
            if (!this.readXRefInfo(repInfo)) {
                return;
            }
            ++this._numTrailers;
            if (this._xrefIsStream) break;
            if (this._startxref == this._prevxref) {
                repInfo.setMessage((Message)new ErrorMessage("Cross reference tables are broken", this._parser.getOffset()));
                repInfo.setWellFormed(false);
                return;
            }
            this._startxref = this._prevxref;
            bl = false;
        }
        if (!this.readDocCatalogDict(repInfo)) {
            return;
        }
        if (!this.readEncryptDict(repInfo)) {
            return;
        }
        if (!this.readDocInfoDict(repInfo)) {
            return;
        }
        if (!this.readDocumentTree(repInfo)) {
            return;
        }
        if (!this.readPageLabelTree(repInfo)) {
            return;
        }
        if (!this.readXMPData(repInfo)) {
            return;
        }
        this.findExternalStreams(repInfo);
        if (!this.findFilters(repInfo)) {
            return;
        }
        this.findImages(repInfo);
        this.findFonts(repInfo);
        Checksummer checksummer = null;
        if (this._je != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            checksummer = new Checksummer();
            this.calcRAChecksum(checksummer, randomAccessFile);
            this.setChecksums(checksummer, repInfo);
        }
        repInfo.setVersion(this._version);
        arrayList.add(new Property("Objects", PropertyType.INTEGER, (Object)new Integer(this._numObjects)));
        arrayList.add(new Property("FreeObjects", PropertyType.INTEGER, (Object)new Integer(this._numFreeObjects)));
        arrayList.add(new Property("IncrementalUpdates", PropertyType.INTEGER, (Object)new Integer(this._numTrailers)));
        if (this._docCatalogList != null) {
            arrayList.add(new Property("DocumentCatalog", PropertyType.PROPERTY, PropertyArity.LIST, this._docCatalogList));
        }
        if (this._encryptList != null) {
            arrayList.add(new Property("Encryption", PropertyType.PROPERTY, PropertyArity.LIST, this._encryptList));
        }
        if (this._docInfoList != null) {
            arrayList.add(new Property("Info", PropertyType.PROPERTY, PropertyArity.LIST, this._docInfoList));
        }
        if (this._idProperty != null) {
            arrayList.add(this._idProperty);
        }
        if (this._extStreamsList != null && !this._extStreamsList.isEmpty()) {
            arrayList.add(new Property("ExternalStreams", PropertyType.PROPERTY, PropertyArity.LIST, this._extStreamsList));
        }
        if (this._filtersList != null && !this._filtersList.isEmpty()) {
            arrayList.add(new Property("Filters", PropertyType.PROPERTY, PropertyArity.LIST, this._filtersList));
        }
        if (this._imagesList != null && !this._imagesList.isEmpty()) {
            arrayList.add(new Property("Images", PropertyType.PROPERTY, PropertyArity.LIST, this._imagesList));
        }
        if (this._showFonts || this._verbosity == 1) {
            try {
                this.addFontsProperty(arrayList);
            }
            catch (NullPointerException nullPointerException) {
                repInfo.setMessage((Message)new ErrorMessage("unexpected error in parsing font property", nullPointerException.toString()));
            }
        }
        if (this._nFonts > this.maxFonts) {
            repInfo.setMessage((Message)new InfoMessage("Too many fonts to report; some fonts omitted.", "Total fonts = " + this._nFonts));
        }
        if (this._xmpProp != null) {
            arrayList.add(this._xmpProp);
        }
        this.addPagesProperty(arrayList, repInfo);
        if (!this.doOutlineStuff(repInfo)) {
            return;
        }
        repInfo.setProperty(this._metadata);
        if (!this._parser.getPDFACompliant()) {
            this._pdfACompliant = false;
        }
        ListIterator<PdfProfile> listIterator = this._profile.listIterator();
        if (repInfo.getWellFormed() == 1) {
            while (listIterator.hasNext()) {
                PdfProfile pdfProfile = listIterator.next();
                if (!pdfProfile.satisfiesProfile(this._raf, this._parser)) continue;
                repInfo.setProfile(pdfProfile.getText());
            }
        }
    }

    public boolean mayBePDFACompliant() {
        return this._pdfACompliant;
    }

    public PageTreeNode getDocumentTree() {
        return this._docTreeRoot;
    }

    public PdfDictionary getDocInfo() {
        return this._docInfoDict;
    }

    public PdfDictionary getEncryptionDict() {
        return this._encryptDict;
    }

    public boolean getActionsExist() {
        return this._actionsExist;
    }

    protected final void initParse() {
        super.initParse();
        this._xref = null;
        this._xref2 = null;
        this._version = "";
        this._objects = null;
        this._numFreeObjects = 0;
        this._objCount = 0;
        this._docInfoList = null;
        this._extStreamsList = null;
        this._docCatalogList = null;
        this._encryptList = null;
        this._imagesList = null;
        this._filtersList = null;
        this._pagesList = null;
        this._type0FontsMap = null;
        this._type1FontsMap = null;
        this._mmFontsMap = null;
        this._type3FontsMap = null;
        this._trueTypeFontsMap = null;
        this._cid0FontsMap = null;
        this._cid2FontsMap = null;
        this._docCatDictRef = null;
        this._encryptDictRef = null;
        this._docInfoDictRef = null;
        this._pagesDictRef = null;
        this._docCatDict = null;
        this._docInfoDict = null;
        this._docTreeRoot = null;
        this._pageLabelDict = null;
        this._encryptDict = null;
        this._trailerDict = null;
        this._viewPrefDict = null;
        this._outlineDict = null;
        this._destsDict = null;
        this._pageSeqMap = null;
        this._pageLabelRoot = null;
        this._embeddedFiles = null;
        this._destNames = null;
        this._skippedFontsReported = false;
        this._skippedOutlinesReported = false;
        this._skippedAnnotationsReported = false;
        this._skippedPagesReported = false;
        this._idProperty = null;
        this._actionsExist = false;
        this._numObjects = 0;
        this._numTrailers = -1;
        this._pdfACompliant = true;
        this._xmpProp = null;
        this._cachedStreamIndex = -1;
        this._nFonts = 0;
    }

    protected boolean parseHeader(RepInfo repInfo) throws IOException {
        Token token = null;
        String string = null;
        boolean bl = false;
        while (this._parser.getOffset() <= 1024L) {
            try {
                token = null;
                token = this._parser.getNext(1024L);
            }
            catch (IOException iOException) {
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (token == null) break;
            if (token instanceof Comment) {
                int n;
                string = ((Comment)token).getValue();
                if (string.indexOf("PDF-1.") == 0) {
                    bl = true;
                    this._version = string.substring(4, 7);
                    repInfo.setSigMatch(this._name);
                    break;
                }
                if (string.indexOf("!PS-Adobe-") == 0 && (n = string.indexOf("PDF-1.")) >= 11) {
                    bl = true;
                    this._version = string.substring(n + 4);
                    this._pdfACompliant = false;
                    repInfo.setSigMatch(this._name);
                    break;
                }
            }
            this._pdfACompliant = false;
        }
        if (!bl) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("No PDF header", 0L));
            return false;
        }
        try {
            token = this._parser.getNext();
            String string2 = ((Comment)token).getValue();
            char[] cArray = string2.toCharArray();
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                if (cArray[i] <= '\u007f') continue;
                ++n;
            }
            if (n < 4) {
                this._pdfACompliant = false;
            }
        }
        catch (Exception exception) {
            this._pdfACompliant = false;
        }
        return true;
    }

    private long lastEOFOffset(RandomAccessFile randomAccessFile) throws IOException {
        long l = 0L;
        long l2 = 0L;
        byte[] byArray = null;
        long l3 = randomAccessFile.getFilePointer();
        l2 = randomAccessFile.length();
        byArray = new byte[(int)Math.min(1024L, l2)];
        l = l2 - (long)byArray.length;
        randomAccessFile.seek(l);
        randomAccessFile.read(byArray);
        randomAccessFile.seek(l3);
        long l4 = -1L;
        for (int i = byArray.length - 4; i >= 1; --i) {
            if (byArray[i] != 37 || byArray[i - 1] != 37 || byArray[i + 1] != 69 || byArray[i + 2] != 79 || byArray[i + 3] != 70) continue;
            l4 = l + (long)i - 1L;
            break;
        }
        return l4;
    }

    private long lastStartXrefOffset(RandomAccessFile randomAccessFile, long l) throws IOException {
        long l2 = 0L;
        long l3 = 0L;
        byte[] byArray = null;
        long l4 = randomAccessFile.getFilePointer();
        l3 = randomAccessFile.length();
        if (l <= 0L) {
            l = l3;
        }
        if (l >= l3) {
            l = l3;
        }
        byArray = new byte[(int)Math.min(128L, l)];
        l2 = l - (long)byArray.length;
        randomAccessFile.seek(l2);
        randomAccessFile.read(byArray);
        randomAccessFile.seek(l4);
        long l5 = -1L;
        for (int i = byArray.length - 9; i >= 0; --i) {
            if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 97 || byArray[i + 3] != 114 || byArray[i + 4] != 116 || byArray[i + 5] != 120 || byArray[i + 6] != 114 || byArray[i + 7] != 101 || byArray[i + 8] != 102) continue;
            l5 = l2 + (long)i;
            break;
        }
        return l5;
    }

    protected boolean findLastTrailer(RepInfo repInfo) throws IOException {
        Token token = null;
        String string = null;
        this._eof = this.lastEOFOffset(this._raf);
        if (this._eof < 0L) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("No PDF trailer", this._raf.length()));
            return false;
        }
        if (this._raf.length() - this._eof > 7L) {
            this._pdfACompliant = false;
        }
        long l = this.lastStartXrefOffset(this._raf, this._eof);
        this._startxref = -1L;
        if (l >= 0L) {
            try {
                this._parser.seek(l);
            }
            catch (PdfException pdfException) {
                // empty catch block
            }
            while (true) {
                try {
                    token = this._parser.getNext();
                }
                catch (Exception exception) {
                    continue;
                }
                if (token == null) break;
                if (!(token instanceof Keyword) || !(string = ((Keyword)token).getValue()).equals("startxref")) continue;
                try {
                    token = this._parser.getNext();
                }
                catch (Exception exception) {
                    break;
                }
                if (token == null || !(token instanceof Numeric)) continue;
                this._startxref = ((Numeric)token).getLongValue();
            }
        }
        if (this._startxref < 0L) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("Missing startxref keyword or value", this._parser.getOffset()));
            return false;
        }
        return true;
    }

    protected boolean parseTrailer(RepInfo repInfo, boolean bl) throws IOException {
        Token token = null;
        String string = null;
        String string2 = "Invalid cross-reference table";
        try {
            this._parser.seek(this._startxref);
            Token token2 = this._parser.getNext();
            if (token2 instanceof Keyword) {
                this._xrefIsStream = false;
                this._parser.getNext(Numeric.class, string2);
                this._objCount = ((Numeric)this._parser.getNext(Numeric.class, string2)).getIntegerValue();
                this._parser.seek(this._parser.getOffset() + (long)(this._objCount * 20));
            } else if (token2 instanceof Numeric) {
                this._xrefIsStream = true;
                this._prevxref = -1L;
                PdfStream pdfStream = (PdfStream)this._parser.readObjectDef((Numeric)token2);
                PdfDictionary pdfDictionary = pdfStream.getDict();
                this._docCatDictRef = (PdfIndirectObj)pdfDictionary.get("Root");
                if (this._docCatDictRef == null) {
                    throw new PdfInvalidException("Root entry missing in cross-ref stream dictionary", this._parser.getOffset());
                }
                return true;
            }
            long l = -1L;
            while ((token = this._parser.getNext()) != null) {
                if (!(token instanceof Keyword) || !(string = ((Keyword)token).getValue()).equals("trailer") || !((token = this._parser.getNext()) instanceof DictionaryStart)) continue;
                l = this._parser.getOffset() - 7L;
                break;
            }
            if (l < 0L) {
                repInfo.setWellFormed(false);
                repInfo.setMessage((Message)new ErrorMessage("No file trailer", this._parser.getOffset()));
                return false;
            }
            this._trailerDict = this._parser.readDictionary();
            this._prevxref = -1L;
            PdfObject pdfObject = this._trailerDict.get("Prev");
            if (pdfObject != null) {
                if (pdfObject != null && pdfObject instanceof PdfSimpleObject && (token = ((PdfSimpleObject)pdfObject).getToken()) instanceof Numeric) {
                    this._prevxref = ((Numeric)token).getLongValue();
                }
                if (this._prevxref < 0L) {
                    throw new PdfInvalidException("Invalid Prev offset in trailer dictionary", this._parser.getOffset());
                }
            }
            if (bl) {
                return true;
            }
            pdfObject = this._trailerDict.get("Size");
            if (pdfObject != null) {
                this._numObjects = -1;
                if (pdfObject != null && pdfObject instanceof PdfSimpleObject) {
                    token = ((PdfSimpleObject)pdfObject).getToken();
                    if (token instanceof Numeric) {
                        this._numObjects = ((Numeric)token).getIntegerValue();
                    }
                    this._xref = new long[this._numObjects];
                }
                if (this._numObjects < 0) {
                    throw new PdfInvalidException("Invalid Size entry in trailer dictionary", this._parser.getOffset());
                }
                if (this._numObjects > 0x7FFFFF) {
                    this._pdfACompliant = false;
                }
            } else {
                throw new PdfInvalidException("Size entry missing in trailer dictionary", this._parser.getOffset());
            }
            this._docCatDictRef = (PdfIndirectObj)this._trailerDict.get("Root");
            if (this._docCatDictRef == null) {
                throw new PdfInvalidException("Root entry missing in trailer dictionary", this._parser.getOffset());
            }
            this._encryptDictRef = (PdfIndirectObj)this._trailerDict.get("Encrypt");
            this._encrypted = this._encryptDictRef != null;
            this._parser.setEncrypted(this._encrypted);
            PdfObject pdfObject2 = this._trailerDict.get("Info");
            if (pdfObject2 != null && !(pdfObject2 instanceof PdfIndirectObj)) {
                throw new PdfInvalidException("Trailer dictionary Info key is not an indirect reference", this._parser.getOffset());
            }
            this._docInfoDictRef = (PdfIndirectObj)pdfObject2;
            pdfObject = this._trailerDict.get("ID");
            if (pdfObject != null) {
                String string3 = "Invalid ID in trailer";
                if (pdfObject instanceof PdfArray) {
                    String[] stringArray = new String[2];
                    try {
                        PdfArray pdfArray = (PdfArray)pdfObject;
                        Vector vector = pdfArray.getContent();
                        if (vector.size() != 2) {
                            throw new PdfInvalidException(string3);
                        }
                        PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)vector.get(0);
                        stringArray[0] = PdfModule.toHex(((StringValuedToken)pdfSimpleObject.getToken()).getRawBytes());
                        pdfSimpleObject = (PdfSimpleObject)vector.get(1);
                        stringArray[1] = PdfModule.toHex(((StringValuedToken)pdfSimpleObject.getToken()).getRawBytes());
                        this._idProperty = new Property("ID", PropertyType.STRING, PropertyArity.ARRAY, (Object)stringArray);
                    }
                    catch (Exception exception) {
                        throw new PdfInvalidException(string3);
                    }
                } else {
                    throw new PdfInvalidException(string3, this._parser.getOffset());
                }
            }
            if ((pdfObject = this._trailerDict.get("XRefStm")) != null) {
                this._logger.warning("Hybrid cross-reference not yet implemented");
            }
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
            return pdfException instanceof PdfInvalidException;
        }
        return true;
    }

    protected boolean readXRefInfo(RepInfo repInfo) throws IOException {
        if (this._xrefIsStream) {
            return this.readXRefStreams(repInfo);
        }
        return this.readXRefTables(repInfo);
    }

    protected boolean readXRefStreams(RepInfo repInfo) throws IOException {
        this._pdfACompliant = false;
        while (this._startxref > 0L) {
            try {
                this._parser.seek(this._startxref);
                PdfStream pdfStream = (PdfStream)this._parser.readObjectDef();
                int n = pdfStream.getObjNumber();
                CrossRefStream crossRefStream = new CrossRefStream(pdfStream);
                if (!crossRefStream.isValid()) {
                    return false;
                }
                crossRefStream.initRead(this._raf);
                int n2 = crossRefStream.getNumObjects();
                if (this._xref == null) {
                    this._xref = new long[n2];
                    this._xref2 = new int[n2][];
                }
                if (n < 0 || n >= n2) {
                    throw new PdfMalformedException("Invalid object number in cross-reference stream", this._parser.getOffset());
                }
                this._xref[n] = this._startxref;
                this._startxref = crossRefStream.getPrevXref();
                try {
                    while (crossRefStream.readNextObject()) {
                        int n3 = crossRefStream.getObjNum();
                        if (crossRefStream.isObjCompressed()) {
                            this._xref[n3] = -1L;
                            this._xref2[n3] = new int[]{crossRefStream.getContentStreamObjNum(), crossRefStream.getContentStreamIndex()};
                            continue;
                        }
                        if (this._xref[n3] != 0L) continue;
                        this._xref[n3] = crossRefStream.getOffset();
                    }
                    this._numFreeObjects += crossRefStream.getFreeCount();
                }
                catch (IOException iOException) {
                    repInfo.setWellFormed(false);
                    repInfo.setMessage((Message)new ErrorMessage("Malformed cross reference stream", this._parser.getOffset()));
                    return false;
                }
            }
            catch (PdfException pdfException) {
                pdfException.disparage(repInfo);
                repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
                return pdfException instanceof PdfInvalidException;
            }
        }
        return true;
    }

    protected boolean readXRefTables(RepInfo repInfo) throws IOException {
        block10: {
            Token token = null;
            String string = "Malformed cross-reference table";
            try {
                this._parser.seek(this._startxref);
                token = this._parser.getNext();
                if (!(token instanceof Keyword)) break block10;
                while ((token = this._parser.getNext()) != null) {
                    int n = 0;
                    if (token instanceof Numeric) {
                        n = ((Numeric)token).getIntegerValue();
                        this._objCount = ((Numeric)this._parser.getNext()).getIntegerValue();
                        for (int i = 0; i < this._objCount; ++i) {
                            String string2;
                            long l = ((Numeric)this._parser.getNext(Numeric.class, string)).getLongValue();
                            this._parser.getNext();
                            if (this._parser.getWSString().length() > 1) {
                                this._pdfACompliant = false;
                            }
                            token = this._parser.getNext(Keyword.class, string);
                            if (this._parser.getWSString().length() > 1) {
                                this._pdfACompliant = false;
                            }
                            if ((string2 = ((Keyword)token).getValue()).equals("n")) {
                                if (this._xref[n + i] != 0L) continue;
                                this._xref[n + i] = l;
                                continue;
                            }
                            if (string2.equals("f")) {
                                ++this._numFreeObjects;
                                continue;
                            }
                            throw new PdfMalformedException("Illegal operator in xref table", this._parser.getOffset());
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (PdfException pdfException) {
                pdfException.disparage(repInfo);
                repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
                return false;
            }
            catch (Exception exception) {
                repInfo.setValid(false);
                repInfo.setMessage((Message)new ErrorMessage(exception.getMessage(), this._parser.getOffset()));
            }
        }
        return true;
    }

    protected boolean readDocCatalogDict(RepInfo repInfo) throws IOException {
        Property property = null;
        this._docCatDict = null;
        this._docCatalogList = new ArrayList<Property>(2);
        if (this._docCatDictRef == null) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("No document catalog dictionary", 0L));
            return false;
        }
        try {
            this._docCatDict = (PdfDictionary)this.resolveIndirectObject(this._docCatDictRef);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._docCatDict == null) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("No document catalog dictionary", 0L));
            return false;
        }
        try {
            Object object;
            Object object2;
            PdfObject pdfObject;
            PdfObject pdfObject2 = this._docCatDict.get("ViewerPreferences");
            pdfObject2 = this.resolveIndirectObject(pdfObject2);
            if (pdfObject2 instanceof PdfDictionary) {
                this._viewPrefDict = (PdfDictionary)pdfObject2;
                property = this.buildViewPrefProperty(this._viewPrefDict);
                this._docCatalogList.add(property);
            }
            String string = "SinglePage";
            PdfObject pdfObject3 = this.resolveIndirectObject(this._docCatDict.get("PageLayout"));
            if (pdfObject3 instanceof PdfSimpleObject) {
                string = ((PdfSimpleObject)pdfObject3).getStringValue();
            }
            property = new Property("PageLayout", PropertyType.STRING, (Object)string);
            this._docCatalogList.add(property);
            String string2 = "UseNone";
            PdfObject pdfObject4 = this.resolveIndirectObject(this._docCatDict.get("PageMode"));
            if (pdfObject4 instanceof PdfSimpleObject) {
                string2 = ((PdfSimpleObject)pdfObject4).getStringValue();
            }
            property = new Property("PageMode", PropertyType.STRING, (Object)string2);
            this._docCatalogList.add(property);
            PdfObject pdfObject5 = this.resolveIndirectObject(this._docCatDict.get("Outlines"));
            if (pdfObject5 instanceof PdfDictionary) {
                this._outlineDict = (PdfDictionary)pdfObject5;
            }
            if ((pdfObject = this.resolveIndirectObject(this._docCatDict.get("Lang"))) != null && pdfObject instanceof PdfSimpleObject) {
                object2 = ((PdfSimpleObject)pdfObject).getStringValue();
                property = new Property("Language", PropertyType.STRING, this._encrypted ? ENCRYPTED : object2);
                this._docCatalogList.add(property);
            }
            this._pagesDictRef = (PdfIndirectObj)this._docCatDict.get("Pages");
            this._pageLabelDict = (PdfDictionary)this.resolveIndirectObject(this._docCatDict.get("PageLabels"));
            object2 = this.resolveIndirectObject(this._docCatDict.get("Version"));
            if (object2 instanceof PdfSimpleObject) {
                String string3 = ((PdfSimpleObject)object2).getStringValue();
                object = this._version;
                try {
                    double d = Double.parseDouble(string3);
                    double d2 = Double.parseDouble((String)object);
                    if (d != d2) {
                        repInfo.setMessage((Message)new InfoMessage("File header gives version as " + string3 + ", but catalog dictionary gives version as " + (String)object));
                    }
                    if (d > d2) {
                        this._version = string3;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PdfInvalidException("Invalid Version in document catalog");
                }
            }
            try {
                object = (PdfDictionary)this.resolveIndirectObject(this._docCatDict.get("Names"));
                if (object != null) {
                    PdfDictionary pdfDictionary;
                    PdfDictionary pdfDictionary2 = (PdfDictionary)this.resolveIndirectObject(((PdfDictionary)object).get("EmbeddedFiles"));
                    if (pdfDictionary2 != null) {
                        this._embeddedFiles = new NameTreeNode(this, null, pdfDictionary2);
                    }
                    if ((pdfDictionary = (PdfDictionary)this.resolveIndirectObject(((PdfDictionary)object).get("Dests"))) != null) {
                        this._destNames = new NameTreeNode(this, null, pdfDictionary);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new PdfInvalidException("Invalid Names dictionary");
            }
            catch (Exception exception) {
                throw new PdfMalformedException("Invalid Names dictionary");
            }
            try {
                this._destsDict = (PdfDictionary)this.resolveIndirectObject(this._docCatDict.get("Dests"));
            }
            catch (ClassCastException classCastException) {
                throw new PdfInvalidException("Invalid Dests dictionary");
            }
            catch (Exception exception) {
                throw new PdfMalformedException("Invalid Dests dictionary");
            }
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
            return pdfException instanceof PdfInvalidException;
        }
        catch (Exception exception) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage(exception.toString(), this._parser.getOffset()));
            return false;
        }
        return true;
    }

    protected boolean readEncryptDict(RepInfo repInfo) throws IOException {
        String string = "";
        String string2 = null;
        if (this._encryptDictRef == null) {
            return true;
        }
        try {
            Object object;
            Token token;
            Token token2;
            Token token3;
            PdfDictionary pdfDictionary;
            this._encryptList = new ArrayList<Property>(6);
            this._encryptDict = pdfDictionary = (PdfDictionary)this.resolveIndirectObject(this._encryptDictRef);
            PdfObject pdfObject = pdfDictionary.get("Filter");
            if (pdfObject instanceof PdfSimpleObject && (token3 = ((PdfSimpleObject)pdfObject).getToken()) instanceof Name) {
                string = ((Name)token3).getValue();
            }
            token3 = new Property("SecurityHandler", PropertyType.STRING, (Object)string);
            this._encryptList.add((Property)token3);
            if (pdfObject instanceof PdfSimpleObject && (token2 = ((PdfSimpleObject)pdfObject).getToken()) instanceof Name) {
                string2 = ((Name)token2).getValue();
            }
            if (string2 != null) {
                token3 = new Property("EFF", PropertyType.STRING, string2);
                this._encryptList.add((Property)token3);
            }
            int n = 0;
            PdfObject pdfObject2 = pdfDictionary.get("V");
            if (pdfObject2 instanceof PdfSimpleObject && (token = ((PdfSimpleObject)pdfObject2).getToken()) instanceof Numeric) {
                n = ((Numeric)token).getIntegerValue();
                if (this._je != null && this._je.getShowRawFlag()) {
                    token3 = new Property("Algorithm", PropertyType.INTEGER, (Object)new Integer(n));
                } else {
                    try {
                        token3 = new Property("Algorithm", PropertyType.STRING, (Object)PdfStrings.ALGORITHM[n]);
                    }
                    catch (Exception exception) {
                        throw new PdfInvalidException("Invalid algorithm value in encryption dictionary", this._parser.getOffset());
                    }
                }
                if (token3 != null) {
                    this._encryptList.add((Property)token3);
                }
            }
            int n2 = 40;
            PdfObject pdfObject3 = pdfDictionary.get("Length");
            if (pdfObject3 instanceof PdfSimpleObject) {
                object = ((PdfSimpleObject)pdfObject3).getToken();
                if (object instanceof Numeric) {
                    n2 = ((Numeric)object).getIntegerValue();
                }
                if (this._je != null) {
                    token3 = new Property("KeyLength", PropertyType.INTEGER, (Object)new Integer(n2));
                    this._encryptList.add((Property)token3);
                }
            }
            if ("Standard".equals(string)) {
                PdfObject pdfObject4;
                String[] stringArray;
                object = new ArrayList(4);
                PdfObject pdfObject5 = pdfDictionary.get("P");
                PdfObject pdfObject6 = pdfDictionary.get("R");
                int n3 = 2;
                if (pdfObject6 instanceof PdfSimpleObject) {
                    n3 = ((PdfSimpleObject)pdfObject6).getIntValue();
                }
                if (pdfObject5 instanceof PdfSimpleObject) {
                    int n4 = ((PdfSimpleObject)pdfObject5).getIntValue();
                    stringArray = n3 == 2 ? PdfStrings.USERPERMFLAGS2 : PdfStrings.USERPERMFLAGS3;
                    token3 = this.buildUserPermProperty(n4, stringArray);
                    object.add(token3);
                    object.add(new Property("Revision", PropertyType.INTEGER, (Object)new Integer(n3)));
                }
                if ((pdfObject4 = pdfDictionary.get("O")) != null && pdfObject4 instanceof PdfSimpleObject) {
                    object.add(new Property("OwnerString", PropertyType.STRING, (Object)PdfModule.toHex(((PdfSimpleObject)pdfObject4).getRawBytes())));
                }
                if ((stringArray = pdfDictionary.get("U")) != null && stringArray instanceof PdfSimpleObject) {
                    object.add(new Property("UserString", PropertyType.STRING, (Object)PdfModule.toHex(((PdfSimpleObject)stringArray).getRawBytes())));
                }
                this._encryptList.add(new Property("StandardSecurityHandler", PropertyType.PROPERTY, PropertyArity.LIST, object));
            }
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
            return pdfException instanceof PdfInvalidException;
        }
        return true;
    }

    protected boolean readDocInfoDict(RepInfo repInfo) throws IOException {
        if (this._docInfoDictRef == null) {
            return true;
        }
        this._docInfoList = new ArrayList<Property>(9);
        try {
            this._docInfoDict = (PdfDictionary)this.resolveIndirectObject(this._docInfoDictRef);
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Title", "Title");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Author", "Author");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Subject", "Subject");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Keywords", "Keywords");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Creator", "Creator");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Producer", "Producer");
            this.addDateProperty(this._docInfoDict, this._docInfoList, "CreationDate", "CreationDate");
            this.addDateProperty(this._docInfoDict, this._docInfoList, "ModDate", "ModDate");
            this.addStringProperty(this._docInfoDict, this._docInfoList, "Trapped", "Trapped");
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
            return pdfException instanceof PdfInvalidException;
        }
        catch (Exception exception) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("Unexpected exception " + exception.getClass().getName()));
        }
        return true;
    }

    protected boolean readDocumentTree(RepInfo repInfo) throws IOException {
        try {
            if (this._pagesDictRef == null) {
                throw new PdfInvalidException("Document page tree not found");
            }
            PdfObject pdfObject = this.resolveIndirectObject(this._pagesDictRef);
            if (!(pdfObject instanceof PdfDictionary)) {
                throw new PdfMalformedException("Invalid page dictionary object");
            }
            PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
            this._docTreeRoot = new PageTreeNode(this, null, pdfDictionary);
            this._docTreeRoot.buildSubtree(true, 100);
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
            return pdfException instanceof PdfInvalidException;
        }
        catch (Exception exception) {
            repInfo.setMessage((Message)new ErrorMessage(exception.getClass().getName(), this._parser.getOffset()));
            repInfo.setWellFormed(false);
            return false;
        }
        return true;
    }

    protected boolean readPageLabelTree(RepInfo repInfo) {
        try {
            if (this._pageLabelDict != null) {
                this._pageLabelRoot = new PageLabelNode(this, null, this._pageLabelDict);
                this._pageLabelRoot.buildSubtree();
            }
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
            return pdfException instanceof PdfInvalidException;
        }
        catch (Exception exception) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("Unexpected exception " + exception.getClass().getName()));
            return false;
        }
        return true;
    }

    protected boolean readXMPData(RepInfo repInfo) {
        block8: {
            try {
                PdfStream pdfStream = (PdfStream)this.resolveIndirectObject(this._docCatDict.get("Metadata"));
                if (pdfStream == null) {
                    return true;
                }
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
                PdfXMPSource pdfXMPSource = new PdfXMPSource(pdfStream, this.getFile());
                XMPHandler xMPHandler = new XMPHandler();
                xMLReader.setContentHandler((ContentHandler)xMPHandler);
                xMLReader.setErrorHandler((ErrorHandler)xMPHandler);
                try {
                    xMLReader.parse((InputSource)((Object)pdfXMPSource));
                    this._xmpProp = pdfXMPSource.makeProperty();
                }
                catch (SAXException sAXException) {
                    String string = sAXException.getMessage();
                    if (string == null || !string.startsWith("ENC=")) break block8;
                    String string2 = string.substring(5);
                    try {
                        pdfXMPSource = new PdfXMPSource(pdfStream, this.getFile(), string2);
                        xMLReader.parse((InputSource)((Object)pdfXMPSource));
                        this._xmpProp = pdfXMPSource.makeProperty();
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new PdfInvalidException("Invalid or ill-formed XMP metadata");
                    }
                }
            }
            catch (PdfException pdfException) {
                pdfException.disparage(repInfo);
                repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
                return pdfException instanceof PdfInvalidException;
            }
            catch (Exception exception) {
                repInfo.setMessage((Message)new ErrorMessage("Invalid or ill-formed XMP metadata", this._parser.getOffset()));
                repInfo.setValid(false);
                return false;
            }
        }
        return true;
    }

    protected void findExternalStreams(RepInfo repInfo) throws IOException {
        this._extStreamsList = new LinkedList<Property>();
        if (this._docTreeRoot == null) {
            return;
        }
        this._docTreeRoot.startWalk();
        try {
            PageObject pageObject;
            while ((pageObject = this._docTreeRoot.nextPageObject()) != null) {
                List list = pageObject.getContentStreams();
                if (list == null) continue;
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    PdfStream pdfStream = (PdfStream)listIterator.next();
                    String string = pdfStream.getFileSpecification();
                    if (string == null) continue;
                    Property property = new Property("File", PropertyType.STRING, (Object)string);
                    this._extStreamsList.add(property);
                }
            }
        }
        catch (Exception exception) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("Unexpected exception " + exception.getClass().getName()));
        }
    }

    protected boolean findFilters(RepInfo repInfo) throws IOException {
        this._filtersList = new LinkedList<Property>();
        if (this._docTreeRoot == null) {
            return false;
        }
        this._docTreeRoot.startWalk();
        try {
            PageObject pageObject;
            while ((pageObject = this._docTreeRoot.nextPageObject()) != null) {
                List list = pageObject.getContentStreams();
                if (list == null) continue;
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    PdfStream pdfStream = (PdfStream)listIterator.next();
                    Filter[] filterArray = pdfStream.getFilters();
                    this.extractFilters(filterArray, pdfStream);
                }
            }
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
            return pdfException instanceof PdfInvalidException;
        }
        return true;
    }

    protected String extractFilters(Filter[] filterArray, PdfStream pdfStream) {
        Object object2;
        int n = filterArray.length;
        if (n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            Filter filter = filterArray[i];
            String string = filter.getFilterName();
            stringBuffer.append(string);
            if ("Crypt".equals(string) && (object2 = filter.getNameParam()) != null) {
                stringBuffer.append(":" + (String)object2);
            }
            if (i >= n - 1) continue;
            stringBuffer.append(' ');
        }
        String string = stringBuffer.toString();
        boolean bl = true;
        for (Object object2 : this._filtersList) {
            String string2 = (String)object2.getValue();
            if (!string2.equals(string)) continue;
            bl = false;
            break;
        }
        if (string != null && bl) {
            object2 = new Property("FilterPipeline", PropertyType.STRING, (Object)string);
            this._filtersList.add((Property)object2);
        }
        return string;
    }

    protected void findImages(RepInfo repInfo) throws IOException {
        this._imagesList = new LinkedList<Property>();
        this._docTreeRoot.startWalk();
        try {
            PageObject pageObject;
            while ((pageObject = this._docTreeRoot.nextPageObject()) != null) {
                PdfDictionary pdfDictionary;
                PdfDictionary pdfDictionary2 = pageObject.getResources();
                if (pdfDictionary2 == null || (pdfDictionary = (PdfDictionary)this.resolveIndirectObject(pdfDictionary2.get("XObject"))) == null) continue;
                Iterator iterator = pdfDictionary.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    PdfArray pdfArray;
                    PdfSimpleObject pdfSimpleObject;
                    Object object5;
                    Object object6;
                    PdfSimpleObject pdfSimpleObject2;
                    PdfDictionary pdfDictionary3 = null;
                    PdfObject pdfObject = this.resolveIndirectObject((PdfObject)iterator.next());
                    if (pdfObject instanceof PdfStream) {
                        pdfDictionary3 = ((PdfStream)pdfObject).getDict();
                    }
                    if (pdfDictionary3 == null || !"Image".equals((pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary3.get("Subtype")).getStringValue())) continue;
                    ArrayList<Property> arrayList = new ArrayList<Property>(10);
                    Property property = new Property("Image", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
                    NisoImageMetadata nisoImageMetadata = new NisoImageMetadata();
                    arrayList.add(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)nisoImageMetadata));
                    nisoImageMetadata.setMimeType("application/pdf");
                    PdfSimpleObject pdfSimpleObject3 = (PdfSimpleObject)pdfDictionary3.get("Width");
                    nisoImageMetadata.setImageWidth((long)pdfSimpleObject3.getIntValue());
                    PdfSimpleObject pdfSimpleObject4 = (PdfSimpleObject)pdfDictionary3.get("Height");
                    nisoImageMetadata.setImageLength((long)pdfSimpleObject4.getIntValue());
                    Filter[] filterArray = ((PdfStream)pdfObject).getFilters();
                    String string = this.extractFilters(filterArray, (PdfStream)pdfObject);
                    if (string != null) {
                        int n = this.nameToNiso(string, compressionStrings, compressionValues);
                        if (n >= 0) {
                            object6 = pdfDictionary3.get("DecodeParms");
                            if (object6 != null) {
                                object5 = null;
                                if (object6 instanceof PdfDictionary) {
                                    object5 = (PdfSimpleObject)((PdfDictionary)object6).get("K");
                                }
                                if (object5 != null) {
                                    int n2 = ((PdfSimpleObject)object5).getIntValue();
                                    if (n2 < 0) {
                                        n = 4;
                                    } else if (n2 > 0) {
                                        n = 3;
                                    }
                                }
                            }
                            nisoImageMetadata.setCompressionScheme(n);
                        } else {
                            arrayList.add(new Property("Filter", PropertyType.STRING, (Object)string));
                        }
                    } else {
                        nisoImageMetadata.setCompressionScheme(1);
                    }
                    PdfObject pdfObject2 = pdfDictionary3.get("ColorSpace");
                    if (pdfObject2 != null) {
                        object6 = null;
                        if (pdfObject2 instanceof PdfSimpleObject) {
                            object6 = ((PdfSimpleObject)pdfObject2).getStringValue();
                        } else if (pdfObject2 instanceof PdfArray) {
                            object5 = ((PdfArray)pdfObject2).getContent();
                            PdfSimpleObject pdfSimpleObject5 = (PdfSimpleObject)((Vector)object5).elementAt(0);
                            object6 = pdfSimpleObject5.getStringValue();
                        }
                        if (object6 != null) {
                            int n = this.nameToNiso((String)object6, colorSpaceStrings, colorSpaceValues);
                            if (n >= 0) {
                                nisoImageMetadata.setColorSpace(n);
                            } else {
                                arrayList.add(new Property("ColorSpace", PropertyType.STRING, object6));
                            }
                        }
                    }
                    if ((object6 = (PdfSimpleObject)pdfDictionary3.get("BitsPerComponent")) != null) {
                        nisoImageMetadata.setBitsPerSample(new int[]{((PdfSimpleObject)object6).getIntValue()});
                    }
                    if ((object5 = (PdfSimpleObject)pdfDictionary3.get("Intent")) != null) {
                        arrayList.add(new Property("Intent", PropertyType.STRING, (Object)((PdfSimpleObject)object5).getStringValue()));
                    }
                    if ((pdfSimpleObject = (PdfSimpleObject)pdfDictionary3.get("ImageMask")) != null) {
                        boolean bl = pdfSimpleObject.isTrue();
                        arrayList.add(new Property("ImageMask", PropertyType.BOOLEAN, (Object)new Boolean(bl)));
                    }
                    if ((pdfArray = (PdfArray)pdfDictionary3.get("Decode")) != null) {
                        object4 = pdfArray.getContent();
                        object3 = new ArrayList(((Vector)object4).size());
                        object2 = ((Vector)object4).iterator();
                        while (object2.hasNext()) {
                            object = (PdfSimpleObject)object2.next();
                            object3.add(new Integer(((PdfSimpleObject)object).getIntValue()));
                        }
                        arrayList.add(new Property("Decode", PropertyType.INTEGER, PropertyArity.LIST, object3));
                    }
                    if ((object4 = (PdfSimpleObject)pdfDictionary3.get("Interpolate")) != null) {
                        boolean bl = ((PdfSimpleObject)object4).isTrue();
                        arrayList.add(new Property("Interpolate", PropertyType.BOOLEAN, (Object)new Boolean(bl)));
                    }
                    if ((object3 = (PdfSimpleObject)pdfDictionary3.get("Name")) != null) {
                        arrayList.add(new Property("Name", PropertyType.STRING, (Object)((PdfSimpleObject)object3).getStringValue()));
                    }
                    if ((object2 = (PdfSimpleObject)this.resolveIndirectObject(pdfDictionary3.get("ID"))) != null) {
                        object = PdfModule.toHex(((PdfSimpleObject)object2).getStringValue());
                        arrayList.add(new Property("ID", PropertyType.STRING, object));
                    }
                    this._imagesList.add(property);
                }
            }
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
        }
        catch (Exception exception) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("Unexpected exception " + exception.getClass().getName()));
        }
    }

    protected int nameToNiso(String string, String[] stringArray, int[] nArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return nArray[i];
        }
        return -1;
    }

    protected void findFonts(RepInfo repInfo) throws IOException {
        this._type0FontsMap = new HashMap<Integer, PdfObject>();
        this._type1FontsMap = new HashMap<Integer, PdfObject>();
        this._trueTypeFontsMap = new HashMap<Integer, PdfObject>();
        this._mmFontsMap = new HashMap<Integer, PdfObject>();
        this._type3FontsMap = new HashMap<Integer, PdfObject>();
        this._cid0FontsMap = new HashMap<Integer, PdfObject>();
        this._cid2FontsMap = new HashMap<Integer, PdfObject>();
        try {
            DocNode docNode;
            this._docTreeRoot.startWalk();
            while ((docNode = this._docTreeRoot.nextDocNode()) != null) {
                PdfDictionary pdfDictionary = null;
                pdfDictionary = docNode.getFontResources();
                if (pdfDictionary == null) continue;
                Iterator iterator = pdfDictionary.iterator();
                while (iterator.hasNext()) {
                    PdfObject pdfObject = (PdfObject)iterator.next();
                    PdfDictionary pdfDictionary2 = (PdfDictionary)this.resolveIndirectObject(pdfObject);
                    this.addFontToMap(pdfDictionary2);
                    if (this._skippedFontsReported || this._showFonts || this._verbosity == 1) continue;
                    repInfo.setMessage((Message)new InfoMessage(fontsSkippedString));
                    this._skippedFontsReported = true;
                }
            }
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
            return;
        }
        catch (Exception exception) {
            this._logger.warning("PdfModule.findFonts: " + exception.toString());
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("Unexpected error in findFonts", exception.toString(), this._parser.getOffset()));
            return;
        }
    }

    protected String addFontToMap(PdfDictionary pdfDictionary) {
        if (++this._nFonts > this.maxFonts) {
            return null;
        }
        String string = null;
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Subtype");
            string = pdfSimpleObject.getStringValue();
            if ("Type0".equals(string)) {
                this._type0FontsMap.put(new Integer(pdfDictionary.getObjNumber()), pdfDictionary);
                PdfObject pdfObject = pdfDictionary.get("DescendantFonts");
                PdfArray pdfArray = (PdfArray)this.resolveIndirectObject(pdfObject);
                Vector vector = pdfArray.getContent();
                for (PdfObject pdfObject2 : vector) {
                    pdfObject2 = this.resolveIndirectObject(pdfObject2);
                    this.addFontToMap((PdfDictionary)pdfObject2);
                }
            } else if ("Type1".equals(string)) {
                this._type1FontsMap.put(new Integer(pdfDictionary.getObjNumber()), pdfDictionary);
            } else if ("MMType1".equals(string)) {
                this._mmFontsMap.put(new Integer(pdfDictionary.getObjNumber()), pdfDictionary);
            } else if ("Type3".equals(string)) {
                this._type3FontsMap.put(new Integer(pdfDictionary.getObjNumber()), pdfDictionary);
            } else if ("TrueType".equals(string)) {
                this._trueTypeFontsMap.put(new Integer(pdfDictionary.getObjNumber()), pdfDictionary);
            } else if ("CIDFontType0".equals(string)) {
                this._cid0FontsMap.put(new Integer(pdfDictionary.getObjNumber()), pdfDictionary);
            } else if ("CIDFontType2".equals(string)) {
                this._cid2FontsMap.put(new Integer(pdfDictionary.getObjNumber()), pdfDictionary);
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static String toHex(String string) {
        StringBuffer stringBuffer = new StringBuffer("0x");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            String string2 = Integer.toHexString(string.charAt(i));
            if (string2.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected static String toHex(Vector<Integer> vector) {
        StringBuffer stringBuffer = new StringBuffer("0x");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            int n2 = vector.elementAt(i);
            String string = Integer.toHexString(n2);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public PdfObject resolveIndirectObject(PdfObject pdfObject) throws PdfException, IOException {
        if (pdfObject instanceof PdfIndirectObj) {
            int n = ((PdfIndirectObj)pdfObject).getObjNumber();
            return this.getObject(n, 30);
        }
        return pdfObject;
    }

    protected PdfObject getObject(int n, int n2) throws PdfException, IOException {
        if (n2 <= 0) {
            throw new PdfMalformedException("Improper nesting of object streams");
        }
        long l = this._xref[n];
        if (l == 0L) {
            return null;
        }
        if (l < 0L) {
            try {
                int n3 = this._xref2[n][0];
                ObjectStream objectStream = null;
                if (n3 == this._cachedStreamIndex) {
                    objectStream = this._cachedObjectStream;
                    if (objectStream.isValid()) {
                        objectStream.readIndex();
                    }
                } else {
                    PdfObject pdfObject = this.resolveIndirectObject(this.getObject(n3, n2 - 1));
                    if (pdfObject instanceof PdfStream) {
                        objectStream = new ObjectStream((PdfStream)pdfObject, this._raf);
                        if (objectStream.isValid()) {
                            objectStream.readIndex();
                            this._cachedObjectStream = objectStream;
                            this._cachedStreamIndex = n3;
                        } else {
                            throw new PdfMalformedException("Invalid object number or object stream");
                        }
                    }
                }
                return objectStream.getObject(n);
            }
            catch (Exception exception) {
                throw new PdfMalformedException("Invalid object number or object stream");
            }
        }
        this._parser.seek(l);
        PdfObject pdfObject = this._parser.readObjectDef();
        pdfObject.setObjNumber(n);
        return pdfObject;
    }

    public RandomAccessFile getFile() {
        return this._raf;
    }

    public PdfDictionary getCatalogDict() {
        return this._docCatDict;
    }

    public PdfDictionary getTrailerDict() {
        return this._trailerDict;
    }

    public PdfDictionary getViewPrefDict() {
        return this._viewPrefDict;
    }

    public PdfDictionary getOutlineDict() {
        return this._outlineDict;
    }

    public Map<Integer, PdfObject> getFontMap(int n) {
        switch (n) {
            case 1: {
                return this._type0FontsMap;
            }
            case 2: {
                return this._type1FontsMap;
            }
            case 3: {
                return this._mmFontsMap;
            }
            case 4: {
                return this._type3FontsMap;
            }
            case 5: {
                return this._mmFontsMap;
            }
            case 6: {
                return this._cid0FontsMap;
            }
            case 7: {
                return this._cid2FontsMap;
            }
        }
        return null;
    }

    public List<Map<Integer, PdfObject>> getFontMaps() {
        ArrayList<Map<Integer, PdfObject>> arrayList = new ArrayList<Map<Integer, PdfObject>>(7);
        arrayList.add(this._type0FontsMap);
        arrayList.add(this._type1FontsMap);
        arrayList.add(this._mmFontsMap);
        arrayList.add(this._type3FontsMap);
        arrayList.add(this._trueTypeFontsMap);
        arrayList.add(this._cid0FontsMap);
        arrayList.add(this._cid2FontsMap);
        return arrayList;
    }

    public NameTreeNode getEmbeddedFiles() {
        return this._embeddedFiles;
    }

    protected void addFontsProperty(List<Property> list) {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        Property property = null;
        if (this._type0FontsMap != null && !this._type0FontsMap.isEmpty()) {
            try {
                property = this.buildFontProperty("Type0", this._type0FontsMap, 1);
                linkedList.add(property);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._type1FontsMap != null && !this._type1FontsMap.isEmpty()) {
            try {
                property = this.buildFontProperty("Type1", this._type1FontsMap, 2);
                linkedList.add(property);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._trueTypeFontsMap != null && !this._trueTypeFontsMap.isEmpty()) {
            try {
                property = this.buildFontProperty("TrueType", this._trueTypeFontsMap, 3);
                linkedList.add(property);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._type3FontsMap != null && !this._type3FontsMap.isEmpty()) {
            try {
                property = this.buildFontProperty("Type3", this._type3FontsMap, 4);
                linkedList.add(property);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._mmFontsMap != null && !this._mmFontsMap.isEmpty()) {
            try {
                property = this.buildFontProperty("MMType1", this._mmFontsMap, 5);
                linkedList.add(property);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._cid0FontsMap != null && !this._cid0FontsMap.isEmpty()) {
            try {
                property = this.buildFontProperty("CIDFontType0", this._cid0FontsMap, 6);
                linkedList.add(property);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._cid2FontsMap != null && !this._cid2FontsMap.isEmpty()) {
            try {
                property = this.buildFontProperty("CIDFontType2", this._cid2FontsMap, 7);
                linkedList.add(property);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (linkedList.size() > 0) {
            list.add(new Property("Fonts", PropertyType.PROPERTY, PropertyArity.LIST, linkedList));
        }
    }

    protected void addPagesProperty(List<Property> list, RepInfo repInfo) {
        this._pagesList = new LinkedList<Property>();
        this._pageSeqMap = new HashMap<Integer, Integer>(500);
        try {
            PageObject pageObject;
            this._docTreeRoot.startWalk();
            int n = 0;
            if (this._pageLabelRoot != null) {
                if (!this._pageLabelRoot.findNextKeyValue()) {
                    throw new PdfMalformedException("Bad page labels");
                }
                this._pageLabelRoot.findNextKeyValue();
            }
            while ((pageObject = this._docTreeRoot.nextPageObject()) != null) {
                this._pageSeqMap.put(new Integer(pageObject.getDict().getObjNumber()), new Integer(n + 1));
            }
            this._docTreeRoot.startWalk();
            while ((pageObject = this._docTreeRoot.nextPageObject()) != null) {
                Property property = this.buildPageProperty(pageObject, n++, repInfo);
                this._pagesList.add(property);
            }
            if (this._showPages || this._verbosity == 1) {
                pageObject = new Property("Pages", PropertyType.PROPERTY, PropertyArity.LIST, this._pagesList);
                list.add((Property)pageObject);
            } else {
                if (!this._skippedPagesReported) {
                    repInfo.setMessage((Message)new InfoMessage(pagesSkippedString));
                }
                this._skippedPagesReported = true;
            }
        }
        catch (PdfException pdfException) {
            pdfException.disparage(repInfo);
            repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
            return;
        }
    }

    protected Property buildPageProperty(PageObject pageObject, int n, RepInfo repInfo) throws PdfException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<Property> arrayList = new ArrayList<Property>(4);
        try {
            object4 = new int[1];
            object3 = this.buildPageLabelProperty(pageObject, n, (int[])object4);
            if (object3 != null) {
                arrayList.add((Property)object3);
            }
            if (object3 == null || object4[0] != n + 1) {
                arrayList.add(new Property("Sequence", PropertyType.INTEGER, (Object)new Integer(n + 1)));
            }
        }
        catch (PdfException pdfException) {
            throw pdfException;
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Invalid page label info");
        }
        try {
            object4 = new LinkedList();
            object3 = pageObject.getAnnotations();
            if (object3 != null) {
                object2 = ((PdfArray)object3).getContent();
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    object = (PdfDictionary)this.resolveIndirectObject((PdfObject)((Vector)object2).elementAt(i));
                    object4.add(this.buildAnnotProperty((PdfDictionary)object, repInfo));
                }
                if (!object4.isEmpty()) {
                    if (this._showAnnotations || this._verbosity == 1) {
                        Property property = new Property("Annotations", PropertyType.PROPERTY, PropertyArity.LIST, object4);
                        arrayList.add(property);
                    } else if (!this._skippedAnnotationsReported) {
                        repInfo.setMessage((Message)new InfoMessage(annotationsSkippedString));
                        this._skippedAnnotationsReported = true;
                    }
                }
            }
        }
        catch (PdfException pdfException) {
            throw pdfException;
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Invalid Annotation list");
        }
        try {
            PdfObject pdfObject;
            object4 = (PdfSimpleObject)pageObject.get("Rotate", true);
            if (object4 != null && ((PdfSimpleObject)object4).getIntValue() != 0) {
                arrayList.add(new Property("Rotate", PropertyType.INTEGER, (Object)new Integer(((PdfSimpleObject)object4).getIntValue())));
            }
            if ((object3 = (PdfSimpleObject)pageObject.get("UserUnit", false)) != null) {
                arrayList.add(new Property("UserUnit", PropertyType.DOUBLE, (Object)new Double(((PdfSimpleObject)object4).getDoubleValue())));
            }
            if ((object2 = (PdfArray)pageObject.get("VP", false)) != null) {
                Vector vector = ((PdfArray)object2).getContent();
                object = vector.iterator();
                ArrayList<Property> arrayList2 = new ArrayList<Property>(vector.size());
                while (object.hasNext()) {
                    PdfDictionary pdfDictionary = (PdfDictionary)this.resolveIndirectObject((PdfObject)object.next());
                    PdfObject pdfObject2 = pdfDictionary.get("BBox");
                    ArrayList<Property> arrayList3 = new ArrayList<Property>();
                    arrayList3.add(this.makeRectProperty((PdfArray)this.resolveIndirectObject(pdfObject2), "BBox"));
                    PdfObject pdfObject3 = pdfDictionary.get("Measure");
                    if (pdfObject3 instanceof PdfDictionary) {
                        arrayList3.add(this.buildMeasureProperty((PdfDictionary)pdfObject3));
                    }
                    arrayList2.add(new Property("Viewport", PropertyType.PROPERTY, PropertyArity.LIST, arrayList3));
                }
                arrayList.add(new Property("Viewports", PropertyType.PROPERTY, PropertyArity.LIST, arrayList2));
            }
            if ((pdfObject = pageObject.get("Thumb", false)) != null) {
                arrayList.add(new Property("Thumb", PropertyType.BOOLEAN, (Object)Boolean.TRUE));
            }
            return new Property("Page", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Invalid page dictionary");
        }
    }

    protected Property buildPageLabelProperty(PageObject pageObject, int n, int[] nArray) throws PdfException {
        if (this._pageLabelRoot == null) {
            return null;
        }
        int n2 = this._pageLabelRoot.getPrevKey();
        int n3 = this._pageLabelRoot.getCurrentKey();
        try {
            PdfSimpleObject pdfSimpleObject;
            int n4;
            if (n >= n3) {
                this._pageLabelRoot.findNextKeyValue();
                n2 = n3;
            }
            PdfDictionary pdfDictionary = (PdfDictionary)this.resolveIndirectObject(this._pageLabelRoot.getPrevValue());
            StringBuffer stringBuffer = new StringBuffer();
            PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary.get("P");
            if (pdfSimpleObject2 != null) {
                stringBuffer.append(pdfSimpleObject2.getStringValue());
            }
            if ((n4 = (pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("St")) != null ? n - n2 + pdfSimpleObject.getIntValue() : n - n2 + 1) <= 0) {
                throw new PdfInvalidException("Invalid page label sequence");
            }
            nArray[0] = n4;
            PdfSimpleObject pdfSimpleObject3 = (PdfSimpleObject)pdfDictionary.get("S");
            String string = pdfSimpleObject3 == null ? null : pdfSimpleObject3.getStringValue();
            if ("D".equals(string)) {
                stringBuffer.append(n4);
            } else if ("R".equals(string)) {
                stringBuffer.append(PageLabelNode.intToRoman(n4, true));
            } else if ("r".equals(string)) {
                stringBuffer.append(PageLabelNode.intToRoman(n4, false));
            } else if ("A".equals(string)) {
                stringBuffer.append(PageLabelNode.intToBase26(n4, true));
            } else if ("a".equals(string)) {
                stringBuffer.append(PageLabelNode.intToBase26(n4, false));
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append("[empty]");
            }
            return new Property("Label", PropertyType.STRING, (Object)stringBuffer.toString());
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Problem with page label structure");
        }
    }

    protected Property buildMeasureProperty(PdfDictionary pdfDictionary) {
        PdfSimpleObject pdfSimpleObject;
        int n;
        double[] dArray;
        Vector vector;
        ArrayList<Property> arrayList = new ArrayList<Property>();
        PdfObject pdfObject = pdfDictionary.get("Subtype");
        if (pdfObject instanceof PdfSimpleObject) {
            arrayList.add(new Property("Subtype", PropertyType.STRING, (Object)((PdfSimpleObject)pdfObject).getStringValue()));
        }
        if ((pdfObject = pdfDictionary.get("R")) instanceof PdfSimpleObject) {
            arrayList.add(new Property("Ratio", PropertyType.STRING, (Object)((PdfSimpleObject)pdfObject).getStringValue()));
        }
        if ((pdfObject = pdfDictionary.get("X")) instanceof PdfArray) {
            vector = ((PdfArray)pdfObject).getContent();
            dArray = new double[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                pdfSimpleObject = (PdfSimpleObject)vector.elementAt(n);
                dArray[n] = pdfSimpleObject.getDoubleValue();
            }
            arrayList.add(new Property("X", PropertyType.DOUBLE, PropertyArity.ARRAY, (Object)dArray));
        }
        if ((pdfObject = pdfDictionary.get("Y")) instanceof PdfArray) {
            vector = ((PdfArray)pdfObject).getContent();
            dArray = new double[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                pdfSimpleObject = (PdfSimpleObject)vector.elementAt(n);
                dArray[n] = pdfSimpleObject.getDoubleValue();
            }
            arrayList.add(new Property("Y", PropertyType.DOUBLE, PropertyArity.ARRAY, (Object)dArray));
        }
        if ((pdfObject = pdfDictionary.get("D")) instanceof PdfArray) {
            vector = ((PdfArray)pdfObject).getContent();
            dArray = new double[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                pdfSimpleObject = (PdfSimpleObject)vector.elementAt(n);
                dArray[n] = pdfSimpleObject.getDoubleValue();
            }
            arrayList.add(new Property("Distance", PropertyType.DOUBLE, PropertyArity.ARRAY, (Object)dArray));
        }
        if ((pdfObject = pdfDictionary.get("A")) instanceof PdfArray) {
            vector = ((PdfArray)pdfObject).getContent();
            dArray = new double[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                pdfSimpleObject = (PdfSimpleObject)vector.elementAt(n);
                dArray[n] = pdfSimpleObject.getDoubleValue();
            }
            arrayList.add(new Property("Area", PropertyType.DOUBLE, PropertyArity.ARRAY, (Object)dArray));
        }
        return new Property("Measure", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
    }

    protected Property buildAnnotProperty(PdfDictionary pdfDictionary, RepInfo repInfo) throws PdfException {
        ArrayList<Property> arrayList = new ArrayList<Property>(7);
        try {
            int n;
            Object object;
            Object object2;
            PdfObject pdfObject = (PdfSimpleObject)pdfDictionary.get("Subtype");
            arrayList.add(new Property("Subtype", PropertyType.STRING, (Object)((PdfSimpleObject)pdfObject).getStringValue()));
            pdfObject = (PdfSimpleObject)pdfDictionary.get("Contents");
            if (pdfObject != null) {
                arrayList.add(new Property("Contents", PropertyType.STRING, (Object)(this._encrypted ? ENCRYPTED : ((PdfSimpleObject)pdfObject).getStringValue())));
            }
            pdfObject = pdfDictionary.get("Rect");
            arrayList.add(this.makeRectProperty((PdfArray)this.resolveIndirectObject(pdfObject), "Rect"));
            pdfObject = pdfDictionary.get("NM");
            if (pdfObject != null) {
                arrayList.add(new Property("Name", PropertyType.STRING, (Object)((PdfSimpleObject)pdfObject).getStringValue()));
            }
            if ((pdfObject = pdfDictionary.get("M")) != null) {
                object2 = (Literal)((PdfSimpleObject)pdfObject).getToken();
                object = new Property("LastModified", PropertyType.STRING, (Object)((StringValuedToken)object2).getValue());
                arrayList.add((Property)object);
            }
            if ((pdfObject = pdfDictionary.get("F")) != null && (object = this.buildBitmaskProperty(n = ((PdfSimpleObject)pdfObject).getIntValue(), "Flags", PdfStrings.ANNOTATIONFLAGS, "No flags set")) != null) {
                arrayList.add((Property)object);
            }
            if ((pdfObject = pdfDictionary.get("AP")) != null) {
                arrayList.add(new Property("AppearanceDictionary", PropertyType.BOOLEAN, (Object)Boolean.TRUE));
            }
            if ((pdfObject = pdfDictionary.get("A")) != null) {
                this._actionsExist = true;
                object2 = (PdfSimpleObject)((PdfDictionary)(pdfObject = this.resolveIndirectObject(pdfObject))).get("S");
                if (object2 == null) {
                    throw new PdfMalformedException("Annotation dictionary missing required type (S) entry");
                }
                if ("GoTo".equals(((PdfSimpleObject)object2).getStringValue()) && (object = ((PdfDictionary)pdfObject).get("D")) != null) {
                    this.addDestination((PdfObject)object, "ActionDest", arrayList, repInfo);
                }
            }
            if ((pdfObject = pdfDictionary.get("Dest")) != null) {
                this.addDestination(pdfObject, "Destination", arrayList, repInfo);
            }
            if ((pdfObject = pdfDictionary.get("RT")) instanceof PdfSimpleObject) {
                object2 = ((PdfSimpleObject)pdfObject).getStringValue();
                arrayList.add(new Property("ReplyType", PropertyType.STRING, object2));
            }
            if ((pdfObject = pdfDictionary.get("IT")) instanceof PdfSimpleObject) {
                object2 = ((PdfSimpleObject)pdfObject).getStringValue();
                arrayList.add(new Property("Intent", PropertyType.STRING, object2));
            }
            if ((pdfObject = pdfDictionary.get("CL")) instanceof PdfArray) {
                object2 = ((PdfArray)pdfObject).getContent();
                object = ((Vector)object2).iterator();
                ArrayList<Double> arrayList2 = new ArrayList<Double>(6);
                while (object.hasNext()) {
                    PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)object.next();
                    arrayList2.add(new Double(pdfSimpleObject.getDoubleValue()));
                }
                arrayList.add(new Property("CalloutLine", PropertyType.DOUBLE, PropertyArity.LIST, arrayList2));
            }
            return new Property("Annotation", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        }
        catch (PdfMalformedException pdfMalformedException) {
            throw pdfMalformedException;
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Invalid Annotation property");
        }
    }

    protected void addDestination(PdfObject pdfObject, String string, List<Property> list, RepInfo repInfo) throws PdfException {
        try {
            Destination destination = new Destination(pdfObject, this, false);
            if (destination.isIndirect()) {
                if (!this._encrypted) {
                    int n = this.resolveIndirectDest(destination.getIndirectDest());
                    if (n == -1) {
                        list.add(new Property(string, PropertyType.STRING, (Object)"External"));
                    } else {
                        list.add(new Property(string, PropertyType.INTEGER, (Object)new Integer(n)));
                    }
                }
            } else {
                int n = destination.getPageDestObjNumber();
                Integer n2 = this._pageSeqMap.get(new Integer(n));
                if (n2 != null) {
                    list.add(new Property(string, PropertyType.INTEGER, (Object)n2));
                }
            }
        }
        catch (Exception exception) {
            list.add(new Property(string, PropertyType.STRING, (Object)"null"));
            repInfo.setMessage((Message)new ErrorMessage(exception.getMessage(), this._parser.getOffset()));
            repInfo.setValid(false);
        }
    }

    protected Property buildFontProperty(String string, Map map, int n) {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        for (PdfDictionary pdfDictionary : map.values()) {
            List list = this.oneFontPropList(pdfDictionary, n);
            Property property = new Property("Font", PropertyType.PROPERTY, PropertyArity.LIST, (Object)list);
            linkedList.add(property);
        }
        return new Property(string, PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
    }

    protected List oneFontPropList(PdfDictionary pdfDictionary, int n) {
        Property property;
        Object object;
        PdfObject pdfObject;
        Object object2;
        LinkedList<Property> linkedList = new LinkedList<Property>();
        if (n == 2 || n == 4 || n == 5 || n == 3) {
            object2 = pdfDictionary.get("Name");
            pdfObject = null;
            if (object2 instanceof PdfSimpleObject) {
                pdfObject = (PdfSimpleObject)object2;
            } else if (object2 instanceof PdfIndirectObj) {
                pdfObject = (PdfSimpleObject)((PdfIndirectObj)object2).getObject();
            }
            if (pdfObject != null) {
                object = ((PdfSimpleObject)pdfObject).getStringValue();
                property = new Property("Name", PropertyType.STRING, object);
                linkedList.add(property);
            }
        }
        object2 = null;
        if (n != 4) {
            pdfObject = pdfDictionary.get("BaseFont");
            object = null;
            if (pdfObject instanceof PdfSimpleObject) {
                object = pdfObject;
            } else if (pdfObject instanceof PdfIndirectObj) {
                object = (PdfSimpleObject)((PdfIndirectObj)pdfObject).getObject();
            }
            if (object != null) {
                object2 = ((PdfSimpleObject)object).getStringValue();
                property = new Property("BaseFont", PropertyType.STRING, object2);
                linkedList.add(property);
            }
        }
        if (n == 6 || n == 7) {
            pdfObject = pdfDictionary.get("CIDSystemInfo");
            try {
                pdfObject = this.resolveIndirectObject(pdfObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pdfObject instanceof PdfDictionary) {
                property = this.buildCIDInfoProperty((PdfDictionary)pdfObject);
                linkedList.add(property);
            }
        }
        if ((n == 2 || n == 3 || n == 5) && this.isFontSubset((String)object2)) {
            property = new Property("FontSubset", PropertyType.BOOLEAN, (Object)Boolean.TRUE);
            linkedList.add(property);
        }
        if (n == 2 || n == 3 || n == 5 || n == 4) {
            pdfObject = pdfDictionary.get("FirstChar");
            if (pdfObject instanceof PdfIndirectObj) {
                pdfObject = ((PdfIndirectObj)pdfObject).getObject();
            }
            try {
                int n2 = ((PdfSimpleObject)pdfObject).getIntValue();
                property = new Property("FirstChar", PropertyType.INTEGER, (Object)new Integer(n2));
                linkedList.add(property);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = pdfDictionary.get("LastChar");
            if (object instanceof PdfIndirectObj) {
                object = ((PdfIndirectObj)object).getObject();
            }
            try {
                int n3 = ((PdfSimpleObject)object).getIntValue();
                property = new Property("LastChar", PropertyType.INTEGER, (Object)new Integer(n3));
                linkedList.add(property);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n == 4) {
            pdfObject = pdfDictionary.get("FontBBox");
            try {
                if (pdfObject instanceof PdfArray) {
                    linkedList.add(this.makeRectProperty((PdfArray)pdfObject, "FontBBox"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n == 2 || n == 3 || n == 5 || n == 6 || n == 7) {
            pdfObject = pdfDictionary.get("FontDescriptor");
            try {
                pdfObject = this.resolveIndirectObject(pdfObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pdfObject instanceof PdfDictionary) {
                property = this.buildFontDescriptorProperty((PdfDictionary)pdfObject);
                linkedList.add(property);
            }
        }
        pdfObject = pdfDictionary.get("Encoding");
        try {
            pdfObject = this.resolveIndirectObject(pdfObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((n == 1 || n == 2 || n == 3 || n == 5 || n == 4) && pdfObject instanceof PdfSimpleObject) {
            property = new Property("Encoding", PropertyType.STRING, (Object)((PdfSimpleObject)pdfObject).getStringValue());
            linkedList.add(property);
        }
        if ((n == 2 || n == 3 || n == 5 || n == 4) && pdfObject != null && pdfObject instanceof PdfDictionary) {
            property = this.buildEncodingDictProperty((PdfDictionary)pdfObject);
            linkedList.add(property);
        }
        if (n == 1 && pdfObject != null && pdfObject instanceof PdfStream) {
            property = this.buildCMapDictProperty((PdfStream)pdfObject);
            linkedList.add(property);
        }
        if (n == 4 && (object = pdfDictionary.get("Resources")) != null) {
            property = new Property("Resources", PropertyType.BOOLEAN, (Object)Boolean.TRUE);
            linkedList.add(property);
        }
        if ((n == 1 || n == 2 || n == 3 || n == 5 || n == 4) && (object = pdfDictionary.get("ToUnicode")) != null) {
            property = new Property("ToUnicode", PropertyType.BOOLEAN, (Object)Boolean.TRUE);
            linkedList.add(property);
        }
        return linkedList;
    }

    protected Property buildCMapDictProperty(PdfStream pdfStream) {
        Property property;
        PdfDictionary pdfDictionary = pdfStream.getDict();
        ArrayList<Property> arrayList = new ArrayList<Property>(4);
        Property property2 = new Property("CMapDictionary", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        PdfObject pdfObject = pdfDictionary.get("CIDSystemInfo");
        LinkedList<Property> linkedList = new LinkedList<Property>();
        try {
            if (pdfObject instanceof PdfDictionary) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)pdfObject;
                property = this.buildCIDInfoProperty(pdfDictionary2);
                linkedList.add(property);
            } else if (pdfObject instanceof PdfArray) {
                Vector vector = ((PdfArray)pdfObject).getContent();
                for (int i = 0; i < vector.size(); ++i) {
                    PdfDictionary pdfDictionary3 = (PdfDictionary)vector.elementAt(i);
                    Property property3 = this.buildCIDInfoProperty(pdfDictionary3);
                    linkedList.add(property3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!linkedList.isEmpty()) {
            property = new Property("CIDSystemInfos", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
            arrayList.add(property);
        }
        return property2;
    }

    protected Property buildCIDInfoProperty(PdfDictionary pdfDictionary) {
        Object object;
        Property property;
        Object object2;
        ArrayList<Property> arrayList = new ArrayList<Property>(3);
        Property property2 = new Property("CIDSystemInfo", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        PdfObject pdfObject = pdfDictionary.get("Registry");
        if (pdfObject instanceof PdfSimpleObject) {
            try {
                object2 = ((PdfSimpleObject)pdfObject).getStringValue();
                property = new Property("Registry", PropertyType.STRING, this._encrypted ? ENCRYPTED : object2);
                arrayList.add(property);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object2 = pdfDictionary.get("Ordering");
        if (pdfObject instanceof PdfSimpleObject) {
            try {
                object = ((PdfSimpleObject)object2).getStringValue();
                property = new Property("Registry", PropertyType.STRING, object);
                arrayList.add(property);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object = pdfDictionary.get("Supplement")) instanceof PdfSimpleObject) {
            try {
                int n = ((PdfSimpleObject)object).getIntValue();
                property = new Property("Supplement", PropertyType.INTEGER, (Object)new Integer(n));
                arrayList.add(property);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return property2;
    }

    protected Property buildEncodingDictProperty(PdfDictionary pdfDictionary) {
        Property property;
        Object object;
        ArrayList<Property> arrayList = new ArrayList<Property>(2);
        Property property2 = new Property("EncodingDictionary", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        PdfObject pdfObject = pdfDictionary.get("BaseEncoding");
        if (pdfObject instanceof PdfSimpleObject && (object = ((PdfSimpleObject)pdfObject).getStringValue()) != null) {
            property = new Property("BaseEncoding", PropertyType.STRING, object);
            arrayList.add(property);
        }
        property = new Property("Differences", PropertyType.BOOLEAN, (Object)new Boolean((object = pdfDictionary.get("Differences")) != null));
        arrayList.add(property);
        return property2;
    }

    protected Property buildFontDescriptorProperty(PdfDictionary pdfDictionary) {
        Property property;
        PdfObject pdfObject;
        ArrayList<Property> arrayList = new ArrayList<Property>(6);
        Property property2 = new Property("FontDescriptor", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        try {
            pdfObject = (PdfSimpleObject)pdfDictionary.get("FontName");
            String string = pdfObject.getStringValue();
            property = new Property("FontName", PropertyType.STRING, (Object)string);
            arrayList.add(property);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            pdfObject = (PdfSimpleObject)pdfDictionary.get("Flags");
            int n = pdfObject.getIntValue();
            property = this.buildBitmaskProperty(n, "Flags", PdfStrings.FONTDESCFLAGS, "No flags set");
            if (property != null) {
                arrayList.add(property);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            pdfObject = (PdfArray)pdfDictionary.get("FontBBox");
            double[] dArray = ((PdfArray)pdfObject).toRectangle();
            if (dArray != null) {
                int[] nArray = new int[4];
                for (int i = 0; i < 4; ++i) {
                    nArray[i] = (int)dArray[i];
                }
                property = new Property("FontBBox", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray);
                arrayList.add(property);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        pdfObject = pdfDictionary.get("FontFile");
        if (pdfObject != null) {
            property = new Property("FontFile", PropertyType.BOOLEAN, (Object)Boolean.TRUE);
            arrayList.add(property);
        }
        if ((pdfObject = pdfDictionary.get("FontFile2")) != null) {
            property = new Property("FontFile2", PropertyType.BOOLEAN, (Object)Boolean.TRUE);
            arrayList.add(property);
        }
        if ((pdfObject = pdfDictionary.get("FontFile3")) != null) {
            property = new Property("FontFile3", PropertyType.BOOLEAN, (Object)Boolean.TRUE);
            arrayList.add(property);
        }
        return property2;
    }

    protected Property buildViewPrefProperty(PdfDictionary pdfDictionary) {
        ArrayList<Property> arrayList = new ArrayList<Property>(12);
        Property property = new Property("ViewerPreferences", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        PdfObject pdfObject = pdfDictionary.get("HideToolbar");
        boolean bl = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).isTrue() : false;
        Property property2 = new Property("HideToolbar", PropertyType.BOOLEAN, (Object)new Boolean(bl));
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("HideMenubar");
        bl = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).isTrue() : false;
        property2 = new Property("HideMenubar", PropertyType.BOOLEAN, (Object)new Boolean(bl));
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("HideWindowUI");
        bl = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).isTrue() : false;
        property2 = new Property("HideWindowUI", PropertyType.BOOLEAN, (Object)new Boolean(bl));
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("FitWindow");
        bl = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).isTrue() : false;
        property2 = new Property("FitWindow", PropertyType.BOOLEAN, (Object)new Boolean(bl));
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("CenterWindow");
        bl = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).isTrue() : false;
        property2 = new Property("CenterWindow", PropertyType.BOOLEAN, (Object)new Boolean(bl));
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("DisplayDocTitle");
        bl = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).isTrue() : false;
        property2 = new Property("DisplayDocTitle", PropertyType.BOOLEAN, (Object)new Boolean(bl));
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("NonFullScreenPageMode");
        String string = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).getStringValue() : "UseNone";
        property2 = new Property("NonFullScreenPageMode", PropertyType.STRING, (Object)string);
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("Direction");
        string = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).getStringValue() : "L2R";
        property2 = new Property("Direction", PropertyType.STRING, (Object)string);
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("ViewArea");
        string = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).getStringValue() : "CropBox";
        property2 = new Property("ViewArea", PropertyType.STRING, (Object)string);
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("ViewClip");
        string = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).getStringValue() : "CropBox";
        property2 = new Property("ViewClip", PropertyType.STRING, (Object)string);
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("PrintArea");
        string = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).getStringValue() : "CropBox";
        property2 = new Property("PrintArea", PropertyType.STRING, (Object)string);
        arrayList.add(property2);
        pdfObject = pdfDictionary.get("PageClip");
        string = pdfObject instanceof PdfSimpleObject ? ((PdfSimpleObject)pdfObject).getStringValue() : "CropBox";
        property2 = new Property("PageClip", PropertyType.STRING, (Object)string);
        arrayList.add(property2);
        return property;
    }

    protected boolean isFontSubset(String string) {
        if (string == null || string.length() < 7) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) continue;
            return false;
        }
        return string.charAt(6) == '+';
    }

    protected Property buildOutlinesProperty(PdfDictionary pdfDictionary, RepInfo repInfo) throws PdfException {
        this._recursionWarned = false;
        this._visitedOutlineNodes = new HashSet<Integer>();
        String string = "Malformed outline dictionary";
        LinkedList<Property> linkedList = new LinkedList<Property>();
        Property property = new Property("Outlines", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
        try {
            PdfObject pdfObject = this.resolveIndirectObject(pdfDictionary.get("First"));
            int n = 0;
            while (pdfObject != null) {
                Integer n2 = new Integer(pdfObject.getObjNumber());
                Property property2 = this.buildOutlineItemProperty((PdfDictionary)pdfObject, repInfo);
                linkedList.add(property2);
                pdfObject = this.resolveIndirectObject(((PdfDictionary)pdfObject).get("Next"));
                if (pdfObject != null) {
                    if (pdfObject.getObjNumber() == n2.intValue()) {
                        if (!this._recursionWarned) {
                            repInfo.setMessage((Message)new InfoMessage(outlinesRecursiveString));
                            this._recursionWarned = true;
                        }
                    } else if (++n <= 2000) continue;
                }
                break;
            }
        }
        catch (PdfException pdfException) {
            throw pdfException;
        }
        catch (Exception exception) {
            throw new PdfMalformedException(string);
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return property;
    }

    protected Property buildOutlineItemProperty(PdfDictionary pdfDictionary, RepInfo repInfo) throws PdfException {
        String string = "Invalid outline dictionary item";
        ArrayList<Property> arrayList = new ArrayList<Property>(3);
        try {
            Object object;
            Object object2;
            PdfObject pdfObject;
            Property property = new Property("Item", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)this.resolveIndirectObject(pdfDictionary.get("Title"));
            if (pdfSimpleObject == null) {
                throw new PdfInvalidException(string);
            }
            arrayList.add(new Property("Title", PropertyType.STRING, (Object)(this._encrypted ? ENCRYPTED : pdfSimpleObject.getStringValue())));
            if (pdfDictionary.get("Parent") == null) {
                throw new PdfInvalidException(string);
            }
            PdfObject pdfObject2 = pdfDictionary.get("Count");
            if (!(pdfObject2 == null || pdfObject2 instanceof PdfSimpleObject && ((PdfSimpleObject)pdfObject2).getToken() instanceof Numeric)) {
                throw new PdfInvalidException(string);
            }
            PdfIndirectObj pdfIndirectObj = (PdfIndirectObj)pdfDictionary.get("Prev");
            pdfIndirectObj = (PdfIndirectObj)pdfDictionary.get("Next");
            pdfIndirectObj = (PdfIndirectObj)pdfDictionary.get("First");
            pdfIndirectObj = (PdfIndirectObj)pdfDictionary.get("First");
            if (pdfDictionary.get("A") != null) {
                this._actionsExist = true;
            }
            if ((pdfObject = pdfDictionary.get("Dest")) != null) {
                object2 = new Destination(pdfObject = this.resolveIndirectObject(pdfObject), this, false);
                if (((Destination)object2).isIndirect()) {
                    arrayList.add(new Property("Destination", PropertyType.STRING, (Object)((Destination)object2).getIndirectDest()));
                } else {
                    int n = ((Destination)object2).getPageDestObjNumber();
                    object = this._pageSeqMap.get(new Integer(n));
                    if (object != null) {
                        arrayList.add(new Property("Destination", PropertyType.INTEGER, object));
                    }
                }
            }
            if ((object2 = (PdfDictionary)this.resolveIndirectObject(pdfDictionary.get("First"))) != null) {
                LinkedList<Property> linkedList = new LinkedList<Property>();
                object = new Property("Children", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
                int n = 0;
                while (object2 != null) {
                    Integer n2 = new Integer(((PdfObject)object2).getObjNumber());
                    if (this._visitedOutlineNodes.contains(n2)) {
                        if (!this._recursionWarned) {
                            repInfo.setMessage((Message)new InfoMessage(outlinesRecursiveString));
                            this._recursionWarned = true;
                        }
                    } else {
                        this._visitedOutlineNodes.add(n2);
                        Property property2 = this.buildOutlineItemProperty((PdfDictionary)object2, repInfo);
                        linkedList.add(property2);
                    }
                    if ((object2 = (PdfDictionary)this.resolveIndirectObject(((PdfDictionary)object2).get("Next"))) == null) break;
                    if (((PdfObject)object2).getObjNumber() == n2.intValue()) {
                        if (this._recursionWarned) break;
                        repInfo.setMessage((Message)new InfoMessage(outlinesRecursiveString));
                        this._recursionWarned = true;
                        break;
                    }
                    if (++n <= 2000) continue;
                    break;
                }
                arrayList.add((Property)object);
            }
            return property;
        }
        catch (PdfException pdfException) {
            throw pdfException;
        }
        catch (ClassCastException classCastException) {
            throw new PdfInvalidException(string);
        }
        catch (Exception exception) {
            throw new PdfInvalidException(string);
        }
    }

    protected boolean doOutlineStuff(RepInfo repInfo) {
        if (this._outlineDict != null) {
            try {
                Property property = this.buildOutlinesProperty(this._outlineDict, repInfo);
                if (this._showOutlines || this._verbosity == 1) {
                    if (property != null) {
                        this._docCatalogList.add(property);
                    }
                } else if (!this._skippedOutlinesReported) {
                    repInfo.setMessage((Message)new InfoMessage(outlinesSkippedString));
                    this._skippedOutlinesReported = true;
                }
            }
            catch (PdfException pdfException) {
                repInfo.setMessage((Message)new ErrorMessage(pdfException.getMessage(), this._parser.getOffset()));
                pdfException.disparage(repInfo);
                return pdfException instanceof PdfInvalidException;
            }
        }
        return true;
    }

    protected int resolveIndirectDest(PdfSimpleObject pdfSimpleObject) throws PdfException {
        if (this._destNames != null) {
            Destination destination = new Destination(this._destNames.get(pdfSimpleObject.getRawBytes()), this, true);
            if (destination == null) {
                return -1;
            }
            return destination.getPageDestObjNumber();
        }
        return -1;
    }

    protected Property buildUserPermProperty(int n, String[] stringArray) {
        return this.buildBitmaskProperty(n, "UserAccess", stringArray, "No permissions");
    }

    protected void addStringProperty(PdfDictionary pdfDictionary, List list, String string, String string2) {
        Token token;
        String string3 = null;
        PdfObject pdfObject = pdfDictionary.get(string);
        if (pdfObject instanceof PdfSimpleObject && (token = ((PdfSimpleObject)pdfObject).getToken()) instanceof Literal) {
            string3 = this._encrypted ? ENCRYPTED : ((Literal)token).getValue();
            list.add(new Property(string2, PropertyType.STRING, (Object)string3));
        }
    }

    protected void addDateProperty(PdfDictionary pdfDictionary, List list, String string, String string2) throws PdfException {
        Token token;
        if (this._encrypted) {
            return;
        }
        PdfObject pdfObject = pdfDictionary.get(string);
        if (pdfObject instanceof PdfSimpleObject && (token = ((PdfSimpleObject)pdfObject).getToken()) instanceof Literal) {
            Date date = ((Literal)token).parseDate();
            if (date != null) {
                list.add(new Property(string2, PropertyType.DATE, (Object)date));
            } else {
                throw new PdfInvalidException("Improperly formed date", 0L);
            }
        }
    }

    protected Property buildBitmaskProperty(int n, String string, String[] stringArray, String string2) {
        if (this._je != null && this._je.getShowRawFlag()) {
            return new Property(string, PropertyType.INTEGER, (Object)new Integer(n));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if ((n & 1 << i) == 0 || stringArray[i].length() <= 0) continue;
                linkedList.add(stringArray[i]);
            }
            if (linkedList.isEmpty() && string2 != null) {
                linkedList.add(string2);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return new Property(string, PropertyType.STRING, PropertyArity.LIST, linkedList);
    }

    protected Property makeRectProperty(PdfArray pdfArray, String string) throws PdfException {
        int[] nArray = new int[4];
        double[] dArray = pdfArray.toRectangle();
        for (int i = 0; i < 4; ++i) {
            nArray[i] = (int)dArray[i];
        }
        return new Property(string, PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray);
    }
}

